/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.serverlessapplicationrepository.AWSServerlessApplicationRepository;
import com.amazonaws.services.serverlessapplicationrepository.AWSServerlessApplicationRepositoryClientBuilder;
import com.amazonaws.services.serverlessapplicationrepository.model.AWSServerlessApplicationRepositoryException;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationVersionResult;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResult;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResult;
import com.amazonaws.services.serverlessapplicationrepository.model.DeleteApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.DeleteApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationPolicyResult;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResult;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationDependenciesResult;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationVersionsResult;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationsResult;
import com.amazonaws.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.PutApplicationPolicyResult;
import com.amazonaws.services.serverlessapplicationrepository.model.UnshareApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.UnshareApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.UpdateApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateApplicationVersionRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateApplicationVersionResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateCloudFormationChangeSetRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateCloudFormationChangeSetResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateCloudFormationTemplateRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.CreateCloudFormationTemplateResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.DeleteApplicationRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetApplicationPolicyRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetApplicationPolicyResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetApplicationRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetApplicationResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetCloudFormationTemplateRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.GetCloudFormationTemplateResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationDependenciesRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationDependenciesResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationVersionsRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationVersionsResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationsRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.PutApplicationPolicyRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.PutApplicationPolicyResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.UnshareApplicationRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.UnshareApplicationResultJsonUnmarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.UpdateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.UpdateApplicationResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSServerlessApplicationRepositoryClient
extends AmazonWebServiceClient
implements AWSServerlessApplicationRepository {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSServerlessApplicationRepository.class);
    private static final String DEFAULT_SIGNING_NAME = "serverlessrepo";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSServerlessApplicationRepositoryException.class));

    public static AWSServerlessApplicationRepositoryClientBuilder builder() {
        return AWSServerlessApplicationRepositoryClientBuilder.standard();
    }

    AWSServerlessApplicationRepositoryClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSServerlessApplicationRepositoryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("serverlessrepo.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/serverlessapplicationrepository/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/serverlessapplicationrepository/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        request = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executeCreateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApplicationResult executeCreateApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestProtocolMarshaller(protocolFactory).marshall((CreateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateApplicationVersionResult createApplicationVersion(CreateApplicationVersionRequest request) {
        request = (CreateApplicationVersionRequest)this.beforeClientExecution(request);
        return this.executeCreateApplicationVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApplicationVersionResult executeCreateApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationVersionRequestProtocolMarshaller(protocolFactory).marshall((CreateApplicationVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateApplicationVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationVersionResult createApplicationVersionResult = (CreateApplicationVersionResult)response.getAwsResponse();
            return createApplicationVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCloudFormationChangeSetResult createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest request) {
        request = (CreateCloudFormationChangeSetRequest)this.beforeClientExecution(request);
        return this.executeCreateCloudFormationChangeSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCloudFormationChangeSetResult executeCreateCloudFormationChangeSet(CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCloudFormationChangeSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCloudFormationChangeSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCloudFormationChangeSetRequestProtocolMarshaller(protocolFactory).marshall((CreateCloudFormationChangeSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCloudFormationChangeSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCloudFormationChangeSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCloudFormationChangeSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCloudFormationChangeSetResult createCloudFormationChangeSetResult = (CreateCloudFormationChangeSetResult)response.getAwsResponse();
            return createCloudFormationChangeSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCloudFormationTemplateResult createCloudFormationTemplate(CreateCloudFormationTemplateRequest request) {
        request = (CreateCloudFormationTemplateRequest)this.beforeClientExecution(request);
        return this.executeCreateCloudFormationTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCloudFormationTemplateResult executeCreateCloudFormationTemplate(CreateCloudFormationTemplateRequest createCloudFormationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCloudFormationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCloudFormationTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCloudFormationTemplateRequestProtocolMarshaller(protocolFactory).marshall((CreateCloudFormationTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCloudFormationTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCloudFormationTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCloudFormationTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCloudFormationTemplateResult createCloudFormationTemplateResult = (CreateCloudFormationTemplateResult)response.getAwsResponse();
            return createCloudFormationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        request = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationResult executeDeleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetApplicationResult getApplication(GetApplicationRequest request) {
        request = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executeGetApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetApplicationResult executeGetApplication(GetApplicationRequest getApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApplicationRequestProtocolMarshaller(protocolFactory).marshall((GetApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApplicationResult getApplicationResult = (GetApplicationResult)response.getAwsResponse();
            return getApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetApplicationPolicyResult getApplicationPolicy(GetApplicationPolicyRequest request) {
        request = (GetApplicationPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetApplicationPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetApplicationPolicyResult executeGetApplicationPolicy(GetApplicationPolicyRequest getApplicationPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getApplicationPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApplicationPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApplicationPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetApplicationPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getApplicationPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetApplicationPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApplicationPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApplicationPolicyResult getApplicationPolicyResult = (GetApplicationPolicyResult)response.getAwsResponse();
            return getApplicationPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCloudFormationTemplateResult getCloudFormationTemplate(GetCloudFormationTemplateRequest request) {
        request = (GetCloudFormationTemplateRequest)this.beforeClientExecution(request);
        return this.executeGetCloudFormationTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCloudFormationTemplateResult executeGetCloudFormationTemplate(GetCloudFormationTemplateRequest getCloudFormationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCloudFormationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCloudFormationTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCloudFormationTemplateRequestProtocolMarshaller(protocolFactory).marshall((GetCloudFormationTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCloudFormationTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCloudFormationTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCloudFormationTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCloudFormationTemplateResult getCloudFormationTemplateResult = (GetCloudFormationTemplateResult)response.getAwsResponse();
            return getCloudFormationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationDependenciesResult listApplicationDependencies(ListApplicationDependenciesRequest request) {
        request = (ListApplicationDependenciesRequest)this.beforeClientExecution(request);
        return this.executeListApplicationDependencies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationDependenciesResult executeListApplicationDependencies(ListApplicationDependenciesRequest listApplicationDependenciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationDependenciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationDependenciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationDependenciesRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationDependenciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationDependenciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplicationDependencies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationDependenciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationDependenciesResult listApplicationDependenciesResult = (ListApplicationDependenciesResult)response.getAwsResponse();
            return listApplicationDependenciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationVersionsResult listApplicationVersions(ListApplicationVersionsRequest request) {
        request = (ListApplicationVersionsRequest)this.beforeClientExecution(request);
        return this.executeListApplicationVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationVersionsResult executeListApplicationVersions(ListApplicationVersionsRequest listApplicationVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationVersionsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplicationVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationVersionsResult listApplicationVersionsResult = (ListApplicationVersionsResult)response.getAwsResponse();
            return listApplicationVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        request = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executeListApplications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationsResult executeListApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutApplicationPolicyResult putApplicationPolicy(PutApplicationPolicyRequest request) {
        request = (PutApplicationPolicyRequest)this.beforeClientExecution(request);
        return this.executePutApplicationPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutApplicationPolicyResult executePutApplicationPolicy(PutApplicationPolicyRequest putApplicationPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putApplicationPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutApplicationPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutApplicationPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutApplicationPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putApplicationPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutApplicationPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutApplicationPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutApplicationPolicyResult putApplicationPolicyResult = (PutApplicationPolicyResult)response.getAwsResponse();
            return putApplicationPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnshareApplicationResult unshareApplication(UnshareApplicationRequest request) {
        request = (UnshareApplicationRequest)this.beforeClientExecution(request);
        return this.executeUnshareApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnshareApplicationResult executeUnshareApplication(UnshareApplicationRequest unshareApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unshareApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnshareApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnshareApplicationRequestProtocolMarshaller(protocolFactory).marshall((UnshareApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)unshareApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UnshareApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnshareApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnshareApplicationResult unshareApplicationResult = (UnshareApplicationResult)response.getAwsResponse();
            return unshareApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        request = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executeUpdateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateApplicationResult executeUpdateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationRequestProtocolMarshaller(protocolFactory).marshall((UpdateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServerlessApplicationRepository");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationResult updateApplicationResult = (UpdateApplicationResult)response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

