/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servermigration.model.GetConnectorsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetConnectorsRequestMarshaller
implements Marshaller<Request<GetConnectorsRequest>, GetConnectorsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetConnectorsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetConnectorsRequest> marshall(GetConnectorsRequest getConnectorsRequest) {
        if (getConnectorsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getConnectorsRequest, "AWSServerMigration");
        request.addHeader("X-Amz-Target", "AWSServerMigrationService_V2016_10_24.GetConnectors");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getConnectorsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(getConnectorsRequest.getNextToken());
            }
            if (getConnectorsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(getConnectorsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

