/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servermigration.model.Server;
import com.amazonaws.services.servermigration.model.transform.VmServerJsonMarshaller;

public class ServerJsonMarshaller {
    private static ServerJsonMarshaller instance;

    public void marshall(Server server, StructuredJsonGenerator jsonGenerator) {
        if (server == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (server.getServerId() != null) {
                jsonGenerator.writeFieldName("serverId").writeValue(server.getServerId());
            }
            if (server.getServerType() != null) {
                jsonGenerator.writeFieldName("serverType").writeValue(server.getServerType());
            }
            if (server.getVmServer() != null) {
                jsonGenerator.writeFieldName("vmServer");
                VmServerJsonMarshaller.getInstance().marshall(server.getVmServer(), jsonGenerator);
            }
            if (server.getReplicationJobId() != null) {
                jsonGenerator.writeFieldName("replicationJobId").writeValue(server.getReplicationJobId());
            }
            if (server.getReplicationJobTerminated() != null) {
                jsonGenerator.writeFieldName("replicationJobTerminated").writeValue(server.getReplicationJobTerminated().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServerJsonMarshaller();
        }
        return instance;
    }
}

