/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.servicecatalog;

import com.amazonaws.services.servicecatalog.model.*;

/**
 * Interface for accessing AWS Service Catalog asynchronously. Each asynchronous
 * method will return a Java Future object representing the asynchronous
 * operation; overloads which accept an {@code AsyncHandler} can be used to
 * receive notification when an asynchronous operation completes.
 * <p>
 * <fullname>AWS Service Catalog</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * <a href="https://aws.amazon.com/servicecatalog/">AWS Service Catalog</a>
 * allows organizations to create and manage catalogs of IT services that are
 * approved for use on AWS. This documentation provides reference material for
 * the AWS Service Catalog end user API. To get the most out of this
 * documentation, you need to be familiar with the terminology discussed in <a
 * href=
 * "http://docs.aws.amazon.com/servicecatalog/latest/userguide/what-is_concepts.html"
 * >AWS Service Catalog Concepts</a>.
 * </p>
 * <p>
 * <i>Additional Resources</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "http://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html"
 * >AWS Service Catalog Administrator Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "http://docs.aws.amazon.com/servicecatalog/latest/userguide/introduction.html"
 * >AWS Service Catalog User Guide</a>
 * </p>
 * </li>
 * </ul>
 */
public interface AWSServiceCatalogAsync extends AWSServiceCatalog {

    /**
     * <p>
     * Retrieves information about a specified product.
     * </p>
     * <p>
     * This operation is functionally identical to <a>DescribeProductView</a>
     * except that it takes as input <code>ProductId</code> instead of
     * <code>ProductViewId</code>.
     * </p>
     * 
     * @param describeProductRequest
     * @return A Java Future containing the result of the DescribeProduct
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.DescribeProduct
     */
    java.util.concurrent.Future<DescribeProductResult> describeProductAsync(
            DescribeProductRequest describeProductRequest);

    /**
     * <p>
     * Retrieves information about a specified product.
     * </p>
     * <p>
     * This operation is functionally identical to <a>DescribeProductView</a>
     * except that it takes as input <code>ProductId</code> instead of
     * <code>ProductViewId</code>.
     * </p>
     * 
     * @param describeProductRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeProduct
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.DescribeProduct
     */
    java.util.concurrent.Future<DescribeProductResult> describeProductAsync(
            DescribeProductRequest describeProductRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeProductRequest, DescribeProductResult> asyncHandler);

    /**
     * <p>
     * Retrieves information about a specified product.
     * </p>
     * <p>
     * This operation is functionally identical to <a>DescribeProduct</a> except
     * that it takes as input <code>ProductViewId</code> instead of
     * <code>ProductId</code>.
     * </p>
     * 
     * @param describeProductViewRequest
     * @return A Java Future containing the result of the DescribeProductView
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.DescribeProductView
     */
    java.util.concurrent.Future<DescribeProductViewResult> describeProductViewAsync(
            DescribeProductViewRequest describeProductViewRequest);

    /**
     * <p>
     * Retrieves information about a specified product.
     * </p>
     * <p>
     * This operation is functionally identical to <a>DescribeProduct</a> except
     * that it takes as input <code>ProductViewId</code> instead of
     * <code>ProductId</code>.
     * </p>
     * 
     * @param describeProductViewRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeProductView
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.DescribeProductView
     */
    java.util.concurrent.Future<DescribeProductViewResult> describeProductViewAsync(
            DescribeProductViewRequest describeProductViewRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeProductViewRequest, DescribeProductViewResult> asyncHandler);

    /**
     * <p>
     * Provides information about parameters required to provision a specified
     * product in a specified manner. Use this operation to obtain the list of
     * <code>ProvisioningArtifactParameters</code> parameters available to call
     * the <a>ProvisionProduct</a> operation for the specified product.
     * </p>
     * 
     * @param describeProvisioningParametersRequest
     * @return A Java Future containing the result of the
     *         DescribeProvisioningParameters operation returned by the service.
     * @sample AWSServiceCatalogAsync.DescribeProvisioningParameters
     */
    java.util.concurrent.Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest);

    /**
     * <p>
     * Provides information about parameters required to provision a specified
     * product in a specified manner. Use this operation to obtain the list of
     * <code>ProvisioningArtifactParameters</code> parameters available to call
     * the <a>ProvisionProduct</a> operation for the specified product.
     * </p>
     * 
     * @param describeProvisioningParametersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         DescribeProvisioningParameters operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.DescribeProvisioningParameters
     */
    java.util.concurrent.Future<DescribeProvisioningParametersResult> describeProvisioningParametersAsync(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResult> asyncHandler);

    /**
     * <p>
     * Retrieves a paginated list of the full details of a specific request. Use
     * this operation after calling a request operation
     * (<a>ProvisionProduct</a>, <a>TerminateProvisionedProduct</a>, or
     * <a>UpdateProvisionedProduct</a>).
     * </p>
     * 
     * @param describeRecordRequest
     * @return A Java Future containing the result of the DescribeRecord
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.DescribeRecord
     */
    java.util.concurrent.Future<DescribeRecordResult> describeRecordAsync(
            DescribeRecordRequest describeRecordRequest);

    /**
     * <p>
     * Retrieves a paginated list of the full details of a specific request. Use
     * this operation after calling a request operation
     * (<a>ProvisionProduct</a>, <a>TerminateProvisionedProduct</a>, or
     * <a>UpdateProvisionedProduct</a>).
     * </p>
     * 
     * @param describeRecordRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeRecord
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.DescribeRecord
     */
    java.util.concurrent.Future<DescribeRecordResult> describeRecordAsync(
            DescribeRecordRequest describeRecordRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeRecordRequest, DescribeRecordResult> asyncHandler);

    /**
     * <p>
     * Returns a paginated list of all paths to a specified product. A path is
     * how the user has access to a specified product, and is necessary when
     * provisioning a product. A path also determines the constraints put on the
     * product.
     * </p>
     * 
     * @param listLaunchPathsRequest
     * @return A Java Future containing the result of the ListLaunchPaths
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.ListLaunchPaths
     */
    java.util.concurrent.Future<ListLaunchPathsResult> listLaunchPathsAsync(
            ListLaunchPathsRequest listLaunchPathsRequest);

    /**
     * <p>
     * Returns a paginated list of all paths to a specified product. A path is
     * how the user has access to a specified product, and is necessary when
     * provisioning a product. A path also determines the constraints put on the
     * product.
     * </p>
     * 
     * @param listLaunchPathsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListLaunchPaths
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.ListLaunchPaths
     */
    java.util.concurrent.Future<ListLaunchPathsResult> listLaunchPathsAsync(
            ListLaunchPathsRequest listLaunchPathsRequest,
            com.amazonaws.handlers.AsyncHandler<ListLaunchPathsRequest, ListLaunchPathsResult> asyncHandler);

    /**
     * <p>
     * Returns a paginated list of all performed requests, in the form of
     * RecordDetails objects that are filtered as specified.
     * </p>
     * 
     * @param listRecordHistoryRequest
     * @return A Java Future containing the result of the ListRecordHistory
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.ListRecordHistory
     */
    java.util.concurrent.Future<ListRecordHistoryResult> listRecordHistoryAsync(
            ListRecordHistoryRequest listRecordHistoryRequest);

    /**
     * <p>
     * Returns a paginated list of all performed requests, in the form of
     * RecordDetails objects that are filtered as specified.
     * </p>
     * 
     * @param listRecordHistoryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListRecordHistory
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.ListRecordHistory
     */
    java.util.concurrent.Future<ListRecordHistoryResult> listRecordHistoryAsync(
            ListRecordHistoryRequest listRecordHistoryRequest,
            com.amazonaws.handlers.AsyncHandler<ListRecordHistoryRequest, ListRecordHistoryResult> asyncHandler);

    /**
     * <p>
     * Requests a <i>Provision</i> of a specified product. A
     * <i>ProvisionedProduct</i> is a resourced instance for a product. For
     * example, provisioning a CloudFormation-template-backed product results in
     * launching a CloudFormation stack and all the underlying resources that
     * come with it.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param provisionProductRequest
     * @return A Java Future containing the result of the ProvisionProduct
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.ProvisionProduct
     */
    java.util.concurrent.Future<ProvisionProductResult> provisionProductAsync(
            ProvisionProductRequest provisionProductRequest);

    /**
     * <p>
     * Requests a <i>Provision</i> of a specified product. A
     * <i>ProvisionedProduct</i> is a resourced instance for a product. For
     * example, provisioning a CloudFormation-template-backed product results in
     * launching a CloudFormation stack and all the underlying resources that
     * come with it.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param provisionProductRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ProvisionProduct
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.ProvisionProduct
     */
    java.util.concurrent.Future<ProvisionProductResult> provisionProductAsync(
            ProvisionProductRequest provisionProductRequest,
            com.amazonaws.handlers.AsyncHandler<ProvisionProductRequest, ProvisionProductResult> asyncHandler);

    /**
     * <p>
     * Returns a paginated list of all the ProvisionedProduct objects that are
     * currently available (not terminated).
     * </p>
     * 
     * @param scanProvisionedProductsRequest
     * @return A Java Future containing the result of the
     *         ScanProvisionedProducts operation returned by the service.
     * @sample AWSServiceCatalogAsync.ScanProvisionedProducts
     */
    java.util.concurrent.Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(
            ScanProvisionedProductsRequest scanProvisionedProductsRequest);

    /**
     * <p>
     * Returns a paginated list of all the ProvisionedProduct objects that are
     * currently available (not terminated).
     * </p>
     * 
     * @param scanProvisionedProductsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         ScanProvisionedProducts operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.ScanProvisionedProducts
     */
    java.util.concurrent.Future<ScanProvisionedProductsResult> scanProvisionedProductsAsync(
            ScanProvisionedProductsRequest scanProvisionedProductsRequest,
            com.amazonaws.handlers.AsyncHandler<ScanProvisionedProductsRequest, ScanProvisionedProductsResult> asyncHandler);

    /**
     * <p>
     * Returns a paginated list all of the <code>Products</code> objects to
     * which the caller has access.
     * </p>
     * <p>
     * The output of this operation can be used as input for other operations,
     * such as <a>DescribeProductView</a>.
     * </p>
     * 
     * @param searchProductsRequest
     * @return A Java Future containing the result of the SearchProducts
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsync.SearchProducts
     */
    java.util.concurrent.Future<SearchProductsResult> searchProductsAsync(
            SearchProductsRequest searchProductsRequest);

    /**
     * <p>
     * Returns a paginated list all of the <code>Products</code> objects to
     * which the caller has access.
     * </p>
     * <p>
     * The output of this operation can be used as input for other operations,
     * such as <a>DescribeProductView</a>.
     * </p>
     * 
     * @param searchProductsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the SearchProducts
     *         operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.SearchProducts
     */
    java.util.concurrent.Future<SearchProductsResult> searchProductsAsync(
            SearchProductsRequest searchProductsRequest,
            com.amazonaws.handlers.AsyncHandler<SearchProductsRequest, SearchProductsResult> asyncHandler);

    /**
     * <p>
     * Requests termination of an existing ProvisionedProduct object. If there
     * are <code>Tags</code> associated with the object, they are terminated
     * when the ProvisionedProduct object is terminated.
     * </p>
     * <p>
     * This operation does not delete any records associated with the
     * ProvisionedProduct object.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param terminateProvisionedProductRequest
     * @return A Java Future containing the result of the
     *         TerminateProvisionedProduct operation returned by the service.
     * @sample AWSServiceCatalogAsync.TerminateProvisionedProduct
     */
    java.util.concurrent.Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest);

    /**
     * <p>
     * Requests termination of an existing ProvisionedProduct object. If there
     * are <code>Tags</code> associated with the object, they are terminated
     * when the ProvisionedProduct object is terminated.
     * </p>
     * <p>
     * This operation does not delete any records associated with the
     * ProvisionedProduct object.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param terminateProvisionedProductRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         TerminateProvisionedProduct operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.TerminateProvisionedProduct
     */
    java.util.concurrent.Future<TerminateProvisionedProductResult> terminateProvisionedProductAsync(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest,
            com.amazonaws.handlers.AsyncHandler<TerminateProvisionedProductRequest, TerminateProvisionedProductResult> asyncHandler);

    /**
     * <p>
     * Requests updates to the configuration of an existing ProvisionedProduct
     * object. If there are tags associated with the object, they cannot be
     * updated or added with this operation. Depending on the specific updates
     * requested, this operation may update with no interruption, with some
     * interruption, or replace the ProvisionedProduct object entirely.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param updateProvisionedProductRequest
     * @return A Java Future containing the result of the
     *         UpdateProvisionedProduct operation returned by the service.
     * @sample AWSServiceCatalogAsync.UpdateProvisionedProduct
     */
    java.util.concurrent.Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(
            UpdateProvisionedProductRequest updateProvisionedProductRequest);

    /**
     * <p>
     * Requests updates to the configuration of an existing ProvisionedProduct
     * object. If there are tags associated with the object, they cannot be
     * updated or added with this operation. Depending on the specific updates
     * requested, this operation may update with no interruption, with some
     * interruption, or replace the ProvisionedProduct object entirely.
     * </p>
     * <p>
     * You can check the status of this request using the <a>DescribeRecord</a>
     * operation.
     * </p>
     * 
     * @param updateProvisionedProductRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         UpdateProvisionedProduct operation returned by the service.
     * @sample AWSServiceCatalogAsyncHandler.UpdateProvisionedProduct
     */
    java.util.concurrent.Future<UpdateProvisionedProductResult> updateProvisionedProductAsync(
            UpdateProvisionedProductRequest updateProvisionedProductRequest,
            com.amazonaws.handlers.AsyncHandler<UpdateProvisionedProductRequest, UpdateProvisionedProductResult> asyncHandler);

}
