/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.servicecatalog.AWSServiceCatalog;
import com.amazonaws.services.servicecatalog.model.AWSServiceCatalogException;
import com.amazonaws.services.servicecatalog.model.DescribeProductRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductResult;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProductViewResult;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import com.amazonaws.services.servicecatalog.model.DescribeProvisioningParametersResult;
import com.amazonaws.services.servicecatalog.model.DescribeRecordRequest;
import com.amazonaws.services.servicecatalog.model.DescribeRecordResult;
import com.amazonaws.services.servicecatalog.model.DuplicateResourceException;
import com.amazonaws.services.servicecatalog.model.InvalidParametersException;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsRequest;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsResult;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryRequest;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryResult;
import com.amazonaws.services.servicecatalog.model.ProvisionProductRequest;
import com.amazonaws.services.servicecatalog.model.ProvisionProductResult;
import com.amazonaws.services.servicecatalog.model.ResourceNotFoundException;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsRequest;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsResult;
import com.amazonaws.services.servicecatalog.model.SearchProductsRequest;
import com.amazonaws.services.servicecatalog.model.SearchProductsResult;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductResult;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductResult;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProductRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProductResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProductViewRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProductViewResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProvisioningParametersRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeProvisioningParametersResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeRecordRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.DescribeRecordResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ListLaunchPathsRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ListLaunchPathsResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ListRecordHistoryRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ListRecordHistoryResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ProvisionProductRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ProvisionProductResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ScanProvisionedProductsRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ScanProvisionedProductsResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.SearchProductsRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.SearchProductsResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.TerminateProvisionedProductRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.TerminateProvisionedProductResultJsonUnmarshaller;
import com.amazonaws.services.servicecatalog.model.transform.UpdateProvisionedProductRequestMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.UpdateProvisionedProductResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSServiceCatalogClient
extends AmazonWebServiceClient
implements AWSServiceCatalog {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSServiceCatalog.class);
    private static final String DEFAULT_SIGNING_NAME = "servicecatalog";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParametersException").withModeledClass(InvalidParametersException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateResourceException").withModeledClass(DuplicateResourceException.class)).withBaseServiceExceptionClass(AWSServiceCatalogException.class));

    public AWSServiceCatalogClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSServiceCatalogClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSServiceCatalogClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSServiceCatalogClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSServiceCatalogClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSServiceCatalogClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSServiceCatalogClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSServiceCatalogClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("servicecatalog.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/servicecatalog/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/servicecatalog/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProductResult describeProduct(DescribeProductRequest describeProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProductRequestMarshaller(this.protocolFactory).marshall((DescribeProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProductResult describeProductResult = (DescribeProductResult)response.getAwsResponse();
            return describeProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProductViewResult describeProductView(DescribeProductViewRequest describeProductViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProductViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProductViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProductViewRequestMarshaller(this.protocolFactory).marshall((DescribeProductViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProductViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProductViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProductViewResult describeProductViewResult = (DescribeProductViewResult)response.getAwsResponse();
            return describeProductViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProvisioningParametersResult describeProvisioningParameters(DescribeProvisioningParametersRequest describeProvisioningParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProvisioningParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProvisioningParametersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProvisioningParametersRequestMarshaller(this.protocolFactory).marshall((DescribeProvisioningParametersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProvisioningParametersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProvisioningParametersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProvisioningParametersResult describeProvisioningParametersResult = (DescribeProvisioningParametersResult)response.getAwsResponse();
            return describeProvisioningParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecordResult describeRecord(DescribeRecordRequest describeRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecordRequestMarshaller(this.protocolFactory).marshall((DescribeRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecordResult describeRecordResult = (DescribeRecordResult)response.getAwsResponse();
            return describeRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLaunchPathsResult listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLaunchPathsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLaunchPathsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLaunchPathsRequestMarshaller(this.protocolFactory).marshall((ListLaunchPathsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLaunchPathsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLaunchPathsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLaunchPathsResult listLaunchPathsResult = (ListLaunchPathsResult)response.getAwsResponse();
            return listLaunchPathsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordHistoryResult listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecordHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordHistoryRequestMarshaller(this.protocolFactory).marshall((ListRecordHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecordHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecordHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecordHistoryResult listRecordHistoryResult = (ListRecordHistoryResult)response.getAwsResponse();
            return listRecordHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionProductResult provisionProduct(ProvisionProductRequest provisionProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(provisionProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ProvisionProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ProvisionProductRequestMarshaller(this.protocolFactory).marshall((ProvisionProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)provisionProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ProvisionProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ProvisionProductResult provisionProductResult = (ProvisionProductResult)response.getAwsResponse();
            return provisionProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanProvisionedProductsResult scanProvisionedProducts(ScanProvisionedProductsRequest scanProvisionedProductsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(scanProvisionedProductsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ScanProvisionedProductsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ScanProvisionedProductsRequestMarshaller(this.protocolFactory).marshall((ScanProvisionedProductsRequest)super.beforeMarshalling((AmazonWebServiceRequest)scanProvisionedProductsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ScanProvisionedProductsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ScanProvisionedProductsResult scanProvisionedProductsResult = (ScanProvisionedProductsResult)response.getAwsResponse();
            return scanProvisionedProductsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchProductsResult searchProducts(SearchProductsRequest searchProductsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchProductsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchProductsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchProductsRequestMarshaller(this.protocolFactory).marshall((SearchProductsRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchProductsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchProductsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchProductsResult searchProductsResult = (SearchProductsResult)response.getAwsResponse();
            return searchProductsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateProvisionedProductResult terminateProvisionedProduct(TerminateProvisionedProductRequest terminateProvisionedProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateProvisionedProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateProvisionedProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateProvisionedProductRequestMarshaller(this.protocolFactory).marshall((TerminateProvisionedProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)terminateProvisionedProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TerminateProvisionedProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TerminateProvisionedProductResult terminateProvisionedProductResult = (TerminateProvisionedProductResult)response.getAwsResponse();
            return terminateProvisionedProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProvisionedProductResult updateProvisionedProduct(UpdateProvisionedProductRequest updateProvisionedProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProvisionedProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProvisionedProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProvisionedProductRequestMarshaller(this.protocolFactory).marshall((UpdateProvisionedProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProvisionedProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProvisionedProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProvisionedProductResult updateProvisionedProductResult = (UpdateProvisionedProductResult)response.getAwsResponse();
            return updateProvisionedProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

