/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicecatalog.model.BudgetDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBudgetsForResourceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<BudgetDetail> budgets;
    private String nextPageToken;

    public List<BudgetDetail> getBudgets() {
        return this.budgets;
    }

    public void setBudgets(Collection<BudgetDetail> budgets) {
        if (budgets == null) {
            this.budgets = null;
            return;
        }
        this.budgets = new ArrayList<BudgetDetail>(budgets);
    }

    public ListBudgetsForResourceResult withBudgets(BudgetDetail ... budgets) {
        if (this.budgets == null) {
            this.setBudgets(new ArrayList<BudgetDetail>(budgets.length));
        }
        for (BudgetDetail ele : budgets) {
            this.budgets.add(ele);
        }
        return this;
    }

    public ListBudgetsForResourceResult withBudgets(Collection<BudgetDetail> budgets) {
        this.setBudgets(budgets);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public ListBudgetsForResourceResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBudgets() != null) {
            sb.append("Budgets: ").append(this.getBudgets()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBudgetsForResourceResult)) {
            return false;
        }
        ListBudgetsForResourceResult other = (ListBudgetsForResourceResult)obj;
        if (other.getBudgets() == null ^ this.getBudgets() == null) {
            return false;
        }
        if (other.getBudgets() != null && !other.getBudgets().equals(this.getBudgets())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBudgets() == null ? 0 : this.getBudgets().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public ListBudgetsForResourceResult clone() {
        try {
            return (ListBudgetsForResourceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

