/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.EventDestination;
import com.amazonaws.services.simpleemail.model.transform.CloudWatchDestinationStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.KinesisFirehoseDestinationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EventDestinationStaxUnmarshaller
implements Unmarshaller<EventDestination, StaxUnmarshallerContext> {
    private static EventDestinationStaxUnmarshaller instance;

    public EventDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventDestination eventDestination = new EventDestination();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventDestination;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    eventDestination.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    eventDestination.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchingEventTypes", targetDepth)) {
                    eventDestination.withMatchingEventTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("MatchingEventTypes/member", targetDepth)) {
                    eventDestination.withMatchingEventTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KinesisFirehoseDestination", targetDepth)) {
                    eventDestination.setKinesisFirehoseDestination(KinesisFirehoseDestinationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudWatchDestination", targetDepth)) continue;
                eventDestination.setCloudWatchDestination(CloudWatchDestinationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventDestination;
    }

    public static EventDestinationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventDestinationStaxUnmarshaller();
        }
        return instance;
    }
}

