/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.S3Action;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3ActionStaxUnmarshaller
implements Unmarshaller<S3Action, StaxUnmarshallerContext> {
    private static S3ActionStaxUnmarshaller instance;

    public S3Action unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Action s3Action = new S3Action();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Action;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    s3Action.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BucketName", targetDepth)) {
                    s3Action.setBucketName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ObjectKeyPrefix", targetDepth)) {
                    s3Action.setObjectKeyPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KmsKeyArn", targetDepth)) continue;
                s3Action.setKmsKeyArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Action;
    }

    public static S3ActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ActionStaxUnmarshaller();
        }
        return instance;
    }
}

