/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemailv2.model.Destination;
import com.amazonaws.services.simpleemailv2.model.EmailContent;
import com.amazonaws.services.simpleemailv2.model.MessageTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendEmailRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fromEmailAddress;
    private Destination destination;
    private List<String> replyToAddresses;
    private String feedbackForwardingEmailAddress;
    private EmailContent content;
    private List<MessageTag> emailTags;
    private String configurationSetName;

    public void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public SendEmailRequest withFromEmailAddress(String fromEmailAddress) {
        this.setFromEmailAddress(fromEmailAddress);
        return this;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public SendEmailRequest withDestination(Destination destination) {
        this.setDestination(destination);
        return this;
    }

    public List<String> getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
            return;
        }
        this.replyToAddresses = new ArrayList<String>(replyToAddresses);
    }

    public SendEmailRequest withReplyToAddresses(String ... replyToAddresses) {
        if (this.replyToAddresses == null) {
            this.setReplyToAddresses(new ArrayList<String>(replyToAddresses.length));
        }
        for (String ele : replyToAddresses) {
            this.replyToAddresses.add(ele);
        }
        return this;
    }

    public SendEmailRequest withReplyToAddresses(Collection<String> replyToAddresses) {
        this.setReplyToAddresses(replyToAddresses);
        return this;
    }

    public void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
        this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
    }

    public String getFeedbackForwardingEmailAddress() {
        return this.feedbackForwardingEmailAddress;
    }

    public SendEmailRequest withFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
        this.setFeedbackForwardingEmailAddress(feedbackForwardingEmailAddress);
        return this;
    }

    public void setContent(EmailContent content) {
        this.content = content;
    }

    public EmailContent getContent() {
        return this.content;
    }

    public SendEmailRequest withContent(EmailContent content) {
        this.setContent(content);
        return this;
    }

    public List<MessageTag> getEmailTags() {
        return this.emailTags;
    }

    public void setEmailTags(Collection<MessageTag> emailTags) {
        if (emailTags == null) {
            this.emailTags = null;
            return;
        }
        this.emailTags = new ArrayList<MessageTag>(emailTags);
    }

    public SendEmailRequest withEmailTags(MessageTag ... emailTags) {
        if (this.emailTags == null) {
            this.setEmailTags(new ArrayList<MessageTag>(emailTags.length));
        }
        for (MessageTag ele : emailTags) {
            this.emailTags.add(ele);
        }
        return this;
    }

    public SendEmailRequest withEmailTags(Collection<MessageTag> emailTags) {
        this.setEmailTags(emailTags);
        return this;
    }

    public void setConfigurationSetName(String configurationSetName) {
        this.configurationSetName = configurationSetName;
    }

    public String getConfigurationSetName() {
        return this.configurationSetName;
    }

    public SendEmailRequest withConfigurationSetName(String configurationSetName) {
        this.setConfigurationSetName(configurationSetName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromEmailAddress() != null) {
            sb.append("FromEmailAddress: ").append(this.getFromEmailAddress()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getReplyToAddresses() != null) {
            sb.append("ReplyToAddresses: ").append(this.getReplyToAddresses()).append(",");
        }
        if (this.getFeedbackForwardingEmailAddress() != null) {
            sb.append("FeedbackForwardingEmailAddress: ").append(this.getFeedbackForwardingEmailAddress()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getEmailTags() != null) {
            sb.append("EmailTags: ").append(this.getEmailTags()).append(",");
        }
        if (this.getConfigurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.getConfigurationSetName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)obj;
        if (other.getFromEmailAddress() == null ^ this.getFromEmailAddress() == null) {
            return false;
        }
        if (other.getFromEmailAddress() != null && !other.getFromEmailAddress().equals(this.getFromEmailAddress())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getReplyToAddresses() == null ^ this.getReplyToAddresses() == null) {
            return false;
        }
        if (other.getReplyToAddresses() != null && !other.getReplyToAddresses().equals(this.getReplyToAddresses())) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddress() == null ^ this.getFeedbackForwardingEmailAddress() == null) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddress() != null && !other.getFeedbackForwardingEmailAddress().equals(this.getFeedbackForwardingEmailAddress())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getEmailTags() == null ^ this.getEmailTags() == null) {
            return false;
        }
        if (other.getEmailTags() != null && !other.getEmailTags().equals(this.getEmailTags())) {
            return false;
        }
        if (other.getConfigurationSetName() == null ^ this.getConfigurationSetName() == null) {
            return false;
        }
        return other.getConfigurationSetName() == null || other.getConfigurationSetName().equals(this.getConfigurationSetName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromEmailAddress() == null ? 0 : this.getFromEmailAddress().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getReplyToAddresses() == null ? 0 : this.getReplyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackForwardingEmailAddress() == null ? 0 : this.getFeedbackForwardingEmailAddress().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getEmailTags() == null ? 0 : this.getEmailTags().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationSetName() == null ? 0 : this.getConfigurationSetName().hashCode());
        return hashCode;
    }

    public SendEmailRequest clone() {
        return (SendEmailRequest)super.clone();
    }
}

