/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.ExportMetric;
import com.amazonaws.services.simpleemailv2.model.MetricNamespace;
import com.amazonaws.services.simpleemailv2.model.transform.MetricsDataSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricsDataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, List<String>> dimensions;
    private String namespace;
    private List<ExportMetric> metrics;
    private Date startDate;
    private Date endDate;

    public Map<String, List<String>> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, List<String>> dimensions) {
        this.dimensions = dimensions;
    }

    public MetricsDataSource withDimensions(Map<String, List<String>> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public MetricsDataSource addDimensionsEntry(String key, List<String> value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, List<String>>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public MetricsDataSource clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetricsDataSource withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public MetricsDataSource withNamespace(MetricNamespace namespace) {
        this.namespace = namespace.toString();
        return this;
    }

    public List<ExportMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<ExportMetric> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new ArrayList<ExportMetric>(metrics);
    }

    public MetricsDataSource withMetrics(ExportMetric ... metrics) {
        if (this.metrics == null) {
            this.setMetrics(new ArrayList<ExportMetric>(metrics.length));
        }
        for (ExportMetric ele : metrics) {
            this.metrics.add(ele);
        }
        return this;
    }

    public MetricsDataSource withMetrics(Collection<ExportMetric> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public MetricsDataSource withStartDate(Date startDate) {
        this.setStartDate(startDate);
        return this;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public MetricsDataSource withEndDate(Date endDate) {
        this.setEndDate(endDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getStartDate() != null) {
            sb.append("StartDate: ").append(this.getStartDate()).append(",");
        }
        if (this.getEndDate() != null) {
            sb.append("EndDate: ").append(this.getEndDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsDataSource)) {
            return false;
        }
        MetricsDataSource other = (MetricsDataSource)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getStartDate() == null ^ this.getStartDate() == null) {
            return false;
        }
        if (other.getStartDate() != null && !other.getStartDate().equals(this.getStartDate())) {
            return false;
        }
        if (other.getEndDate() == null ^ this.getEndDate() == null) {
            return false;
        }
        return other.getEndDate() == null || other.getEndDate().equals(this.getEndDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getStartDate() == null ? 0 : this.getStartDate().hashCode());
        hashCode = 31 * hashCode + (this.getEndDate() == null ? 0 : this.getEndDate().hashCode());
        return hashCode;
    }

    public MetricsDataSource clone() {
        try {
            return (MetricsDataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricsDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

