/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemailv2.model.SuppressionListReason;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListSuppressedDestinationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> reasons;
    private Date startDate;
    private Date endDate;
    private String nextToken;
    private Integer pageSize;

    public List<String> getReasons() {
        return this.reasons;
    }

    public void setReasons(Collection<String> reasons) {
        if (reasons == null) {
            this.reasons = null;
            return;
        }
        this.reasons = new ArrayList<String>(reasons);
    }

    public ListSuppressedDestinationsRequest withReasons(String ... reasons) {
        if (this.reasons == null) {
            this.setReasons(new ArrayList<String>(reasons.length));
        }
        for (String ele : reasons) {
            this.reasons.add(ele);
        }
        return this;
    }

    public ListSuppressedDestinationsRequest withReasons(Collection<String> reasons) {
        this.setReasons(reasons);
        return this;
    }

    public ListSuppressedDestinationsRequest withReasons(SuppressionListReason ... reasons) {
        ArrayList<String> reasonsCopy = new ArrayList<String>(reasons.length);
        for (SuppressionListReason value : reasons) {
            reasonsCopy.add(value.toString());
        }
        if (this.getReasons() == null) {
            this.setReasons(reasonsCopy);
        } else {
            this.getReasons().addAll(reasonsCopy);
        }
        return this;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public ListSuppressedDestinationsRequest withStartDate(Date startDate) {
        this.setStartDate(startDate);
        return this;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public ListSuppressedDestinationsRequest withEndDate(Date endDate) {
        this.setEndDate(endDate);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSuppressedDestinationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public ListSuppressedDestinationsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReasons() != null) {
            sb.append("Reasons: ").append(this.getReasons()).append(",");
        }
        if (this.getStartDate() != null) {
            sb.append("StartDate: ").append(this.getStartDate()).append(",");
        }
        if (this.getEndDate() != null) {
            sb.append("EndDate: ").append(this.getEndDate()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuppressedDestinationsRequest)) {
            return false;
        }
        ListSuppressedDestinationsRequest other = (ListSuppressedDestinationsRequest)obj;
        if (other.getReasons() == null ^ this.getReasons() == null) {
            return false;
        }
        if (other.getReasons() != null && !other.getReasons().equals(this.getReasons())) {
            return false;
        }
        if (other.getStartDate() == null ^ this.getStartDate() == null) {
            return false;
        }
        if (other.getStartDate() != null && !other.getStartDate().equals(this.getStartDate())) {
            return false;
        }
        if (other.getEndDate() == null ^ this.getEndDate() == null) {
            return false;
        }
        if (other.getEndDate() != null && !other.getEndDate().equals(this.getEndDate())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        return other.getPageSize() == null || other.getPageSize().equals(this.getPageSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReasons() == null ? 0 : this.getReasons().hashCode());
        hashCode = 31 * hashCode + (this.getStartDate() == null ? 0 : this.getStartDate().hashCode());
        hashCode = 31 * hashCode + (this.getEndDate() == null ? 0 : this.getEndDate().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        return hashCode;
    }

    public ListSuppressedDestinationsRequest clone() {
        return (ListSuppressedDestinationsRequest)super.clone();
    }
}

