
/**
 * Synchronous and asynchronous client classes for accessing AmazonSimpleWorkflow.
 *
 * Amazon Simple Workflow Service <p>
 * The Amazon Simple Workflow Service (Amazon SWF) makes it easy to build
 * applications that use Amazon's cloud to coordinate work across
 * distributed components. In Amazon SWF, a <i>task</i> represents a
 * logical unit of work that is performed by a component of your
 * workflow. Coordinating tasks in a workflow involves managing intertask
 * dependencies, scheduling, and concurrency in accordance with the
 * logical flow of the application.
 * </p>
 * <p>
 * Amazon SWF gives you full control over implementing tasks and
 * coordinating them without worrying about underlying complexities such
 * as tracking their progress and maintaining their state.
 * </p>
 * <p>
 * This documentation serves as reference only. For a broader overview of
 * the Amazon SWF programming model, see the
 * <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/"> Amazon SWF Developer Guide </a>
 * .
 * </p>
 */
 package com.amazonaws.services.simpleworkflow;
        