/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.JobMetadata;
import com.amazonaws.services.snowball.model.transform.DataTransferJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.JobLogsJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.ShippingDetailsJsonMarshaller;

public class JobMetadataJsonMarshaller {
    private static JobMetadataJsonMarshaller instance;

    public void marshall(JobMetadata jobMetadata, StructuredJsonGenerator jsonGenerator) {
        if (jobMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (jobMetadata.getJobId() != null) {
                jsonGenerator.writeFieldName("JobId").writeValue(jobMetadata.getJobId());
            }
            if (jobMetadata.getJobState() != null) {
                jsonGenerator.writeFieldName("JobState").writeValue(jobMetadata.getJobState());
            }
            if (jobMetadata.getJobType() != null) {
                jsonGenerator.writeFieldName("JobType").writeValue(jobMetadata.getJobType());
            }
            if (jobMetadata.getSnowballType() != null) {
                jsonGenerator.writeFieldName("SnowballType").writeValue(jobMetadata.getSnowballType());
            }
            if (jobMetadata.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(jobMetadata.getCreationDate());
            }
            if (jobMetadata.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(jobMetadata.getResources(), jsonGenerator);
            }
            if (jobMetadata.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(jobMetadata.getDescription());
            }
            if (jobMetadata.getKmsKeyARN() != null) {
                jsonGenerator.writeFieldName("KmsKeyARN").writeValue(jobMetadata.getKmsKeyARN());
            }
            if (jobMetadata.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(jobMetadata.getRoleARN());
            }
            if (jobMetadata.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(jobMetadata.getAddressId());
            }
            if (jobMetadata.getShippingDetails() != null) {
                jsonGenerator.writeFieldName("ShippingDetails");
                ShippingDetailsJsonMarshaller.getInstance().marshall(jobMetadata.getShippingDetails(), jsonGenerator);
            }
            if (jobMetadata.getSnowballCapacityPreference() != null) {
                jsonGenerator.writeFieldName("SnowballCapacityPreference").writeValue(jobMetadata.getSnowballCapacityPreference());
            }
            if (jobMetadata.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(jobMetadata.getNotification(), jsonGenerator);
            }
            if (jobMetadata.getDataTransferProgress() != null) {
                jsonGenerator.writeFieldName("DataTransferProgress");
                DataTransferJsonMarshaller.getInstance().marshall(jobMetadata.getDataTransferProgress(), jsonGenerator);
            }
            if (jobMetadata.getJobLogInfo() != null) {
                jsonGenerator.writeFieldName("JobLogInfo");
                JobLogsJsonMarshaller.getInstance().marshall(jobMetadata.getJobLogInfo(), jsonGenerator);
            }
            if (jobMetadata.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(jobMetadata.getClusterId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobMetadataJsonMarshaller();
        }
        return instance;
    }
}

