/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.snowdevicemanagement.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.snowdevicemanagement.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeDeviceResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeDeviceResultJsonUnmarshaller implements Unmarshaller<DescribeDeviceResult, JsonUnmarshallerContext> {

    public DescribeDeviceResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeDeviceResult describeDeviceResult = new DescribeDeviceResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeDeviceResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("associatedWithJob", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setAssociatedWithJob(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deviceCapacities", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setDeviceCapacities(new ListUnmarshaller<Capacity>(CapacityJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("deviceState", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setDeviceState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deviceType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setDeviceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastReachedOutAt", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setLastReachedOutAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastUpdatedAt", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setLastUpdatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("managedDeviceArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setManagedDeviceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("managedDeviceId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setManagedDeviceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("physicalNetworkInterfaces", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setPhysicalNetworkInterfaces(new ListUnmarshaller<PhysicalNetworkInterface>(PhysicalNetworkInterfaceJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("software", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setSoftware(SoftwareInformationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeDeviceResult.setTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeDeviceResult;
    }

    private static DescribeDeviceResultJsonUnmarshaller instance;

    public static DescribeDeviceResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeDeviceResultJsonUnmarshaller();
        return instance;
    }
}
