/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.AddPermissionResult;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutResult;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.services.sns.model.DeleteEndpointResult;
import com.amazonaws.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.services.sns.model.DeletePlatformApplicationResult;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.DeleteTopicResult;
import com.amazonaws.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.GetSMSAttributesRequest;
import com.amazonaws.services.sns.model.GetSMSAttributesResult;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutRequest;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutResult;
import com.amazonaws.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.OptInPhoneNumberRequest;
import com.amazonaws.services.sns.model.OptInPhoneNumberResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.RemovePermissionResult;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.SetEndpointAttributesResult;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.SetSMSAttributesRequest;
import com.amazonaws.services.sns.model.SetSMSAttributesResult;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesResult;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sns.model.UnsubscribeResult;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSNSAsyncClient
extends AmazonSNSClient
implements AmazonSNSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonSNSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSNSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSNSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request) {
        return this.addPermissionAsync(request, null);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(final AddPermissionRequest request, final AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                AddPermissionResult result;
                try {
                    result = AmazonSNSAsyncClient.this.addPermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) {
        return this.addPermissionAsync(new AddPermissionRequest().withTopicArn(topicArn).withLabel(label).withAWSAccountIds(aWSAccountIds).withActionNames(actionNames));
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames, AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.addPermissionAsync(new AddPermissionRequest().withTopicArn(topicArn).withLabel(label).withAWSAccountIds(aWSAccountIds).withActionNames(actionNames), asyncHandler);
    }

    @Override
    public Future<CheckIfPhoneNumberIsOptedOutResult> checkIfPhoneNumberIsOptedOutAsync(CheckIfPhoneNumberIsOptedOutRequest request) {
        return this.checkIfPhoneNumberIsOptedOutAsync(request, null);
    }

    @Override
    public Future<CheckIfPhoneNumberIsOptedOutResult> checkIfPhoneNumberIsOptedOutAsync(final CheckIfPhoneNumberIsOptedOutRequest request, final AsyncHandler<CheckIfPhoneNumberIsOptedOutRequest, CheckIfPhoneNumberIsOptedOutResult> asyncHandler) {
        return this.executorService.submit(new Callable<CheckIfPhoneNumberIsOptedOutResult>(){

            @Override
            public CheckIfPhoneNumberIsOptedOutResult call() throws Exception {
                CheckIfPhoneNumberIsOptedOutResult result;
                try {
                    result = AmazonSNSAsyncClient.this.checkIfPhoneNumberIsOptedOut(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(ConfirmSubscriptionRequest request) {
        return this.confirmSubscriptionAsync(request, null);
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(final ConfirmSubscriptionRequest request, final AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmSubscriptionResult>(){

            @Override
            public ConfirmSubscriptionResult call() throws Exception {
                ConfirmSubscriptionResult result;
                try {
                    result = AmazonSNSAsyncClient.this.confirmSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, String authenticateOnUnsubscribe) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token).withAuthenticateOnUnsubscribe(authenticateOnUnsubscribe));
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, String authenticateOnUnsubscribe, AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token).withAuthenticateOnUnsubscribe(authenticateOnUnsubscribe), asyncHandler);
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token));
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token), asyncHandler);
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(CreatePlatformApplicationRequest request) {
        return this.createPlatformApplicationAsync(request, null);
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(final CreatePlatformApplicationRequest request, final AsyncHandler<CreatePlatformApplicationRequest, CreatePlatformApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePlatformApplicationResult>(){

            @Override
            public CreatePlatformApplicationResult call() throws Exception {
                CreatePlatformApplicationResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createPlatformApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(CreatePlatformEndpointRequest request) {
        return this.createPlatformEndpointAsync(request, null);
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(final CreatePlatformEndpointRequest request, final AsyncHandler<CreatePlatformEndpointRequest, CreatePlatformEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePlatformEndpointResult>(){

            @Override
            public CreatePlatformEndpointResult call() throws Exception {
                CreatePlatformEndpointResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createPlatformEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(CreateTopicRequest request) {
        return this.createTopicAsync(request, null);
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(final CreateTopicRequest request, final AsyncHandler<CreateTopicRequest, CreateTopicResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTopicResult>(){

            @Override
            public CreateTopicResult call() throws Exception {
                CreateTopicResult result;
                try {
                    result = AmazonSNSAsyncClient.this.createTopic(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(String name) {
        return this.createTopicAsync(new CreateTopicRequest().withName(name));
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(String name, AsyncHandler<CreateTopicRequest, CreateTopicResult> asyncHandler) {
        return this.createTopicAsync(new CreateTopicRequest().withName(name), asyncHandler);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(final DeleteEndpointRequest request, final AsyncHandler<DeleteEndpointRequest, DeleteEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteEndpointResult>(){

            @Override
            public DeleteEndpointResult call() throws Exception {
                DeleteEndpointResult result;
                try {
                    result = AmazonSNSAsyncClient.this.deleteEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePlatformApplicationResult> deletePlatformApplicationAsync(DeletePlatformApplicationRequest request) {
        return this.deletePlatformApplicationAsync(request, null);
    }

    @Override
    public Future<DeletePlatformApplicationResult> deletePlatformApplicationAsync(final DeletePlatformApplicationRequest request, final AsyncHandler<DeletePlatformApplicationRequest, DeletePlatformApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePlatformApplicationResult>(){

            @Override
            public DeletePlatformApplicationResult call() throws Exception {
                DeletePlatformApplicationResult result;
                try {
                    result = AmazonSNSAsyncClient.this.deletePlatformApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(DeleteTopicRequest request) {
        return this.deleteTopicAsync(request, null);
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(final DeleteTopicRequest request, final AsyncHandler<DeleteTopicRequest, DeleteTopicResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTopicResult>(){

            @Override
            public DeleteTopicResult call() throws Exception {
                DeleteTopicResult result;
                try {
                    result = AmazonSNSAsyncClient.this.deleteTopic(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(String topicArn) {
        return this.deleteTopicAsync(new DeleteTopicRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(String topicArn, AsyncHandler<DeleteTopicRequest, DeleteTopicResult> asyncHandler) {
        return this.deleteTopicAsync(new DeleteTopicRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(GetEndpointAttributesRequest request) {
        return this.getEndpointAttributesAsync(request, null);
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(final GetEndpointAttributesRequest request, final AsyncHandler<GetEndpointAttributesRequest, GetEndpointAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetEndpointAttributesResult>(){

            @Override
            public GetEndpointAttributesResult call() throws Exception {
                GetEndpointAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getEndpointAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(GetPlatformApplicationAttributesRequest request) {
        return this.getPlatformApplicationAttributesAsync(request, null);
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(final GetPlatformApplicationAttributesRequest request, final AsyncHandler<GetPlatformApplicationAttributesRequest, GetPlatformApplicationAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPlatformApplicationAttributesResult>(){

            @Override
            public GetPlatformApplicationAttributesResult call() throws Exception {
                GetPlatformApplicationAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getPlatformApplicationAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSMSAttributesResult> getSMSAttributesAsync(GetSMSAttributesRequest request) {
        return this.getSMSAttributesAsync(request, null);
    }

    @Override
    public Future<GetSMSAttributesResult> getSMSAttributesAsync(final GetSMSAttributesRequest request, final AsyncHandler<GetSMSAttributesRequest, GetSMSAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSMSAttributesResult>(){

            @Override
            public GetSMSAttributesResult call() throws Exception {
                GetSMSAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getSMSAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(GetSubscriptionAttributesRequest request) {
        return this.getSubscriptionAttributesAsync(request, null);
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(final GetSubscriptionAttributesRequest request, final AsyncHandler<GetSubscriptionAttributesRequest, GetSubscriptionAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSubscriptionAttributesResult>(){

            @Override
            public GetSubscriptionAttributesResult call() throws Exception {
                GetSubscriptionAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getSubscriptionAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(String subscriptionArn) {
        return this.getSubscriptionAttributesAsync(new GetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn));
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(String subscriptionArn, AsyncHandler<GetSubscriptionAttributesRequest, GetSubscriptionAttributesResult> asyncHandler) {
        return this.getSubscriptionAttributesAsync(new GetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn), asyncHandler);
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(GetTopicAttributesRequest request) {
        return this.getTopicAttributesAsync(request, null);
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(final GetTopicAttributesRequest request, final AsyncHandler<GetTopicAttributesRequest, GetTopicAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTopicAttributesResult>(){

            @Override
            public GetTopicAttributesResult call() throws Exception {
                GetTopicAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.getTopicAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(String topicArn) {
        return this.getTopicAttributesAsync(new GetTopicAttributesRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(String topicArn, AsyncHandler<GetTopicAttributesRequest, GetTopicAttributesResult> asyncHandler) {
        return this.getTopicAttributesAsync(new GetTopicAttributesRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(ListEndpointsByPlatformApplicationRequest request) {
        return this.listEndpointsByPlatformApplicationAsync(request, null);
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(final ListEndpointsByPlatformApplicationRequest request, final AsyncHandler<ListEndpointsByPlatformApplicationRequest, ListEndpointsByPlatformApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListEndpointsByPlatformApplicationResult>(){

            @Override
            public ListEndpointsByPlatformApplicationResult call() throws Exception {
                ListEndpointsByPlatformApplicationResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listEndpointsByPlatformApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPhoneNumbersOptedOutResult> listPhoneNumbersOptedOutAsync(ListPhoneNumbersOptedOutRequest request) {
        return this.listPhoneNumbersOptedOutAsync(request, null);
    }

    @Override
    public Future<ListPhoneNumbersOptedOutResult> listPhoneNumbersOptedOutAsync(final ListPhoneNumbersOptedOutRequest request, final AsyncHandler<ListPhoneNumbersOptedOutRequest, ListPhoneNumbersOptedOutResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPhoneNumbersOptedOutResult>(){

            @Override
            public ListPhoneNumbersOptedOutResult call() throws Exception {
                ListPhoneNumbersOptedOutResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listPhoneNumbersOptedOut(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(ListPlatformApplicationsRequest request) {
        return this.listPlatformApplicationsAsync(request, null);
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(final ListPlatformApplicationsRequest request, final AsyncHandler<ListPlatformApplicationsRequest, ListPlatformApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPlatformApplicationsResult>(){

            @Override
            public ListPlatformApplicationsResult call() throws Exception {
                ListPlatformApplicationsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listPlatformApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync() {
        return this.listPlatformApplicationsAsync(new ListPlatformApplicationsRequest());
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(AsyncHandler<ListPlatformApplicationsRequest, ListPlatformApplicationsResult> asyncHandler) {
        return this.listPlatformApplicationsAsync(new ListPlatformApplicationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(ListSubscriptionsRequest request) {
        return this.listSubscriptionsAsync(request, null);
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(final ListSubscriptionsRequest request, final AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSubscriptionsResult>(){

            @Override
            public ListSubscriptionsResult call() throws Exception {
                ListSubscriptionsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listSubscriptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync() {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest());
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest(), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(String nextToken) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest().withNextToken(nextToken));
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(String nextToken, AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest().withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(ListSubscriptionsByTopicRequest request) {
        return this.listSubscriptionsByTopicAsync(request, null);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(final ListSubscriptionsByTopicRequest request, final AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSubscriptionsByTopicResult>(){

            @Override
            public ListSubscriptionsByTopicResult call() throws Exception {
                ListSubscriptionsByTopicResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listSubscriptionsByTopic(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, String nextToken) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn).withNextToken(nextToken));
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, String nextToken, AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn).withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(ListTopicsRequest request) {
        return this.listTopicsAsync(request, null);
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(final ListTopicsRequest request, final AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTopicsResult>(){

            @Override
            public ListTopicsResult call() throws Exception {
                ListTopicsResult result;
                try {
                    result = AmazonSNSAsyncClient.this.listTopics(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync() {
        return this.listTopicsAsync(new ListTopicsRequest());
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        return this.listTopicsAsync(new ListTopicsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(String nextToken) {
        return this.listTopicsAsync(new ListTopicsRequest().withNextToken(nextToken));
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(String nextToken, AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        return this.listTopicsAsync(new ListTopicsRequest().withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<OptInPhoneNumberResult> optInPhoneNumberAsync(OptInPhoneNumberRequest request) {
        return this.optInPhoneNumberAsync(request, null);
    }

    @Override
    public Future<OptInPhoneNumberResult> optInPhoneNumberAsync(final OptInPhoneNumberRequest request, final AsyncHandler<OptInPhoneNumberRequest, OptInPhoneNumberResult> asyncHandler) {
        return this.executorService.submit(new Callable<OptInPhoneNumberResult>(){

            @Override
            public OptInPhoneNumberResult call() throws Exception {
                OptInPhoneNumberResult result;
                try {
                    result = AmazonSNSAsyncClient.this.optInPhoneNumber(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(PublishRequest request) {
        return this.publishAsync(request, null);
    }

    @Override
    public Future<PublishResult> publishAsync(final PublishRequest request, final AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        return this.executorService.submit(new Callable<PublishResult>(){

            @Override
            public PublishResult call() throws Exception {
                PublishResult result;
                try {
                    result = AmazonSNSAsyncClient.this.publish(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message));
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message), asyncHandler);
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, String subject) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message).withSubject(subject));
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, String subject, AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message).withSubject(subject), asyncHandler);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(final RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result;
                try {
                    result = AmazonSNSAsyncClient.this.removePermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String topicArn, String label) {
        return this.removePermissionAsync(new RemovePermissionRequest().withTopicArn(topicArn).withLabel(label));
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String topicArn, String label, AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.removePermissionAsync(new RemovePermissionRequest().withTopicArn(topicArn).withLabel(label), asyncHandler);
    }

    @Override
    public Future<SetEndpointAttributesResult> setEndpointAttributesAsync(SetEndpointAttributesRequest request) {
        return this.setEndpointAttributesAsync(request, null);
    }

    @Override
    public Future<SetEndpointAttributesResult> setEndpointAttributesAsync(final SetEndpointAttributesRequest request, final AsyncHandler<SetEndpointAttributesRequest, SetEndpointAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetEndpointAttributesResult>(){

            @Override
            public SetEndpointAttributesResult call() throws Exception {
                SetEndpointAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.setEndpointAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetPlatformApplicationAttributesResult> setPlatformApplicationAttributesAsync(SetPlatformApplicationAttributesRequest request) {
        return this.setPlatformApplicationAttributesAsync(request, null);
    }

    @Override
    public Future<SetPlatformApplicationAttributesResult> setPlatformApplicationAttributesAsync(final SetPlatformApplicationAttributesRequest request, final AsyncHandler<SetPlatformApplicationAttributesRequest, SetPlatformApplicationAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetPlatformApplicationAttributesResult>(){

            @Override
            public SetPlatformApplicationAttributesResult call() throws Exception {
                SetPlatformApplicationAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.setPlatformApplicationAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSMSAttributesResult> setSMSAttributesAsync(SetSMSAttributesRequest request) {
        return this.setSMSAttributesAsync(request, null);
    }

    @Override
    public Future<SetSMSAttributesResult> setSMSAttributesAsync(final SetSMSAttributesRequest request, final AsyncHandler<SetSMSAttributesRequest, SetSMSAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetSMSAttributesResult>(){

            @Override
            public SetSMSAttributesResult call() throws Exception {
                SetSMSAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.setSMSAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(SetSubscriptionAttributesRequest request) {
        return this.setSubscriptionAttributesAsync(request, null);
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(final SetSubscriptionAttributesRequest request, final AsyncHandler<SetSubscriptionAttributesRequest, SetSubscriptionAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetSubscriptionAttributesResult>(){

            @Override
            public SetSubscriptionAttributesResult call() throws Exception {
                SetSubscriptionAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.setSubscriptionAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(String subscriptionArn, String attributeName, String attributeValue) {
        return this.setSubscriptionAttributesAsync(new SetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn).withAttributeName(attributeName).withAttributeValue(attributeValue));
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(String subscriptionArn, String attributeName, String attributeValue, AsyncHandler<SetSubscriptionAttributesRequest, SetSubscriptionAttributesResult> asyncHandler) {
        return this.setSubscriptionAttributesAsync(new SetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn).withAttributeName(attributeName).withAttributeValue(attributeValue), asyncHandler);
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(SetTopicAttributesRequest request) {
        return this.setTopicAttributesAsync(request, null);
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(final SetTopicAttributesRequest request, final AsyncHandler<SetTopicAttributesRequest, SetTopicAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetTopicAttributesResult>(){

            @Override
            public SetTopicAttributesResult call() throws Exception {
                SetTopicAttributesResult result;
                try {
                    result = AmazonSNSAsyncClient.this.setTopicAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(String topicArn, String attributeName, String attributeValue) {
        return this.setTopicAttributesAsync(new SetTopicAttributesRequest().withTopicArn(topicArn).withAttributeName(attributeName).withAttributeValue(attributeValue));
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(String topicArn, String attributeName, String attributeValue, AsyncHandler<SetTopicAttributesRequest, SetTopicAttributesResult> asyncHandler) {
        return this.setTopicAttributesAsync(new SetTopicAttributesRequest().withTopicArn(topicArn).withAttributeName(attributeName).withAttributeValue(attributeValue), asyncHandler);
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(SubscribeRequest request) {
        return this.subscribeAsync(request, null);
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(final SubscribeRequest request, final AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubscribeResult>(){

            @Override
            public SubscribeResult call() throws Exception {
                SubscribeResult result;
                try {
                    result = AmazonSNSAsyncClient.this.subscribe(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(String topicArn, String protocol, String endpoint) {
        return this.subscribeAsync(new SubscribeRequest().withTopicArn(topicArn).withProtocol(protocol).withEndpoint(endpoint));
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(String topicArn, String protocol, String endpoint, AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) {
        return this.subscribeAsync(new SubscribeRequest().withTopicArn(topicArn).withProtocol(protocol).withEndpoint(endpoint), asyncHandler);
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(UnsubscribeRequest request) {
        return this.unsubscribeAsync(request, null);
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(final UnsubscribeRequest request, final AsyncHandler<UnsubscribeRequest, UnsubscribeResult> asyncHandler) {
        return this.executorService.submit(new Callable<UnsubscribeResult>(){

            @Override
            public UnsubscribeResult call() throws Exception {
                UnsubscribeResult result;
                try {
                    result = AmazonSNSAsyncClient.this.unsubscribe(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(String subscriptionArn) {
        return this.unsubscribeAsync(new UnsubscribeRequest().withSubscriptionArn(subscriptionArn));
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(String subscriptionArn, AsyncHandler<UnsubscribeRequest, UnsubscribeResult> asyncHandler) {
        return this.unsubscribeAsync(new UnsubscribeRequest().withSubscriptionArn(subscriptionArn), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

