/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.OptInPhoneNumberRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class OptInPhoneNumberRequestMarshaller
implements Marshaller<Request<OptInPhoneNumberRequest>, OptInPhoneNumberRequest> {
    public Request<OptInPhoneNumberRequest> marshall(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        if (optInPhoneNumberRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)optInPhoneNumberRequest, "AmazonSNS");
        request.addParameter("Action", "OptInPhoneNumber");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (optInPhoneNumberRequest.getPhoneNumber() != null) {
            request.addParameter("phoneNumber", StringUtils.fromString((String)optInPhoneNumberRequest.getPhoneNumber()));
        }
        return request;
    }
}

