/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreatePlatformEndpointRequestMarshaller
implements Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {
    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        if (createPlatformEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformEndpointRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformEndpointRequest.getPlatformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringUtils.fromString((String)createPlatformEndpointRequest.getPlatformApplicationArn()));
        }
        if (createPlatformEndpointRequest.getToken() != null) {
            request.addParameter("Token", StringUtils.fromString((String)createPlatformEndpointRequest.getToken()));
        }
        if (createPlatformEndpointRequest.getCustomUserData() != null) {
            request.addParameter("CustomUserData", StringUtils.fromString((String)createPlatformEndpointRequest.getCustomUserData()));
        }
        Map<String, String> attributes = createPlatformEndpointRequest.getAttributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

