/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ConfirmSubscriptionRequestMarshaller
implements Marshaller<Request<ConfirmSubscriptionRequest>, ConfirmSubscriptionRequest> {
    public Request<ConfirmSubscriptionRequest> marshall(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        if (confirmSubscriptionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmSubscriptionRequest, "AmazonSNS");
        request.addParameter("Action", "ConfirmSubscription");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (confirmSubscriptionRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)confirmSubscriptionRequest.getTopicArn()));
        }
        if (confirmSubscriptionRequest.getToken() != null) {
            request.addParameter("Token", StringUtils.fromString((String)confirmSubscriptionRequest.getToken()));
        }
        if (confirmSubscriptionRequest.getAuthenticateOnUnsubscribe() != null) {
            request.addParameter("AuthenticateOnUnsubscribe", StringUtils.fromString((String)confirmSubscriptionRequest.getAuthenticateOnUnsubscribe()));
        }
        return request;
    }
}

