/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.message.SignatureVerifier;
import com.amazonaws.services.sns.message.SnsMessage;
import com.amazonaws.services.sns.message.SnsMessageHandler;
import com.amazonaws.services.sns.message.SnsMessageUnmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SnsMessageManager {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final HttpClient client = HttpClientBuilder.create().build();
    private final SignatureVerifier signatureVerifier;
    private final SnsMessageUnmarshaller messageUnmarshaller;
    private final String endpoint;

    public SnsMessageManager() {
        this(new DefaultAwsRegionProviderChain().getRegion());
    }

    public SnsMessageManager(String region) {
        this.endpoint = RegionUtils.getRegion((String)region).getServiceEndpoint("sns");
        this.signatureVerifier = new SignatureVerifier(this.client, this.endpoint, this.resolveCertCommonName(region));
        this.messageUnmarshaller = new SnsMessageUnmarshaller(this.client);
    }

    @SdkTestInternalApi
    SnsMessageManager(String region, SignatureVerifier signatureVerifier) {
        this.endpoint = RegionUtils.getRegion((String)region).getServiceEndpoint("sns");
        this.signatureVerifier = signatureVerifier;
        this.messageUnmarshaller = new SnsMessageUnmarshaller(this.client);
    }

    public SnsMessage parseMessage(InputStream messageBody) {
        JsonNode messageJson = this.toJson(messageBody);
        this.signatureVerifier.verifySignature(messageJson);
        return this.messageUnmarshaller.unmarshall(messageJson);
    }

    public void handleMessage(InputStream messageBody, SnsMessageHandler handler) {
        this.parseMessage(messageBody).handle(handler);
    }

    private JsonNode toJson(InputStream messageBody) {
        try {
            return MAPPER.readTree(messageBody);
        }
        catch (IOException e) {
            throw new SdkClientException("Could not parse message as JSON.", (Throwable)e);
        }
    }

    @SdkTestInternalApi
    String resolveCertCommonName(String regionStr) {
        Regions region;
        try {
            region = Regions.fromName((String)regionStr);
        }
        catch (IllegalArgumentException exception) {
            return "sns." + RegionUtils.getRegion((String)regionStr).getDomain();
        }
        switch (region) {
            case CN_NORTH_1: {
                return "sns-cn-north-1.amazonaws.com.cn";
            }
            case CN_NORTHWEST_1: {
                return "sns-cn-northwest-1.amazonaws.com.cn";
            }
            case GovCloud: 
            case US_GOV_EAST_1: {
                return "sns-us-gov-west-1.amazonaws.com";
            }
            case US_ISO_EAST_1: {
                return "sns-us-iso-east-1.c2s.ic.gov";
            }
            case US_ISOB_EAST_1: {
                return "sns-us-isob-east-1.sc2s.sgov.gov";
            }
            case AP_EAST_1: 
            case ME_SOUTH_1: 
            case ME_CENTRAL_1: 
            case EU_SOUTH_1: 
            case EU_CENTRAL_2: 
            case AF_SOUTH_1: 
            case AP_SOUTHEAST_3: {
                return "sns-signing." + regionStr + ".amazonaws.com";
            }
        }
        return "sns.amazonaws.com";
    }
}

