/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmcontacts;

import javax.annotation.Generated;

import com.amazonaws.services.ssmcontacts.model.*;

/**
 * Abstract implementation of {@code AWSSSMContactsAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSMContactsAsync extends AbstractAWSSSMContacts implements AWSSSMContactsAsync {

    protected AbstractAWSSSMContactsAsync() {
    }

    @Override
    public java.util.concurrent.Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request) {

        return acceptPageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request,
            com.amazonaws.handlers.AsyncHandler<AcceptPageRequest, AcceptPageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request) {

        return activateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<ActivateContactChannelRequest, ActivateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateContactResult> createContactAsync(CreateContactRequest request) {

        return createContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateContactResult> createContactAsync(CreateContactRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateContactRequest, CreateContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request) {

        return createContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateContactChannelRequest, CreateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request) {

        return deactivateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeactivateContactChannelRequest, DeactivateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request) {

        return deleteContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteContactRequest, DeleteContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request) {

        return deleteContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteContactChannelRequest, DeleteContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request) {

        return describeEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeEngagementRequest, DescribeEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePageResult> describePageAsync(DescribePageRequest request) {

        return describePageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePageResult> describePageAsync(DescribePageRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePageRequest, DescribePageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactResult> getContactAsync(GetContactRequest request) {

        return getContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactResult> getContactAsync(GetContactRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactRequest, GetContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request) {

        return getContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactChannelRequest, GetContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request) {

        return getContactPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactPolicyRequest, GetContactPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request) {

        return listContactChannelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListContactChannelsRequest, ListContactChannelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListContactsResult> listContactsAsync(ListContactsRequest request) {

        return listContactsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListContactsResult> listContactsAsync(ListContactsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListContactsRequest, ListContactsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request) {

        return listEngagementsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEngagementsRequest, ListEngagementsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request) {

        return listPageReceiptsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPageReceiptsRequest, ListPageReceiptsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request) {

        return listPagesByContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPagesByContactRequest, ListPagesByContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request) {

        return listPagesByEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPagesByEngagementRequest, ListPagesByEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request) {

        return putContactPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutContactPolicyRequest, PutContactPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request) {

        return sendActivationCodeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request,
            com.amazonaws.handlers.AsyncHandler<SendActivationCodeRequest, SendActivationCodeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request) {

        return startEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<StartEngagementRequest, StartEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request) {

        return stopEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<StopEngagementRequest, StopEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request) {

        return updateContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateContactRequest, UpdateContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request) {

        return updateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateContactChannelRequest, UpdateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
