/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmincidents.model.AutomationExecution;
import com.amazonaws.services.ssmincidents.model.ChatChannel;
import com.amazonaws.services.ssmincidents.model.IncidentRecordSource;
import com.amazonaws.services.ssmincidents.model.IncidentRecordStatus;
import com.amazonaws.services.ssmincidents.model.NotificationTargetItem;
import com.amazonaws.services.ssmincidents.model.transform.IncidentRecordMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class IncidentRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<AutomationExecution> automationExecutions;
    private ChatChannel chatChannel;
    private Date creationTime;
    private String dedupeString;
    private Integer impact;
    private IncidentRecordSource incidentRecordSource;
    private String lastModifiedBy;
    private Date lastModifiedTime;
    private List<NotificationTargetItem> notificationTargets;
    private Date resolvedTime;
    private String status;
    private String summary;
    private String title;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public IncidentRecord withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<AutomationExecution> getAutomationExecutions() {
        return this.automationExecutions;
    }

    public void setAutomationExecutions(Collection<AutomationExecution> automationExecutions) {
        if (automationExecutions == null) {
            this.automationExecutions = null;
            return;
        }
        this.automationExecutions = new ArrayList<AutomationExecution>(automationExecutions);
    }

    public IncidentRecord withAutomationExecutions(AutomationExecution ... automationExecutions) {
        if (this.automationExecutions == null) {
            this.setAutomationExecutions(new ArrayList<AutomationExecution>(automationExecutions.length));
        }
        for (AutomationExecution ele : automationExecutions) {
            this.automationExecutions.add(ele);
        }
        return this;
    }

    public IncidentRecord withAutomationExecutions(Collection<AutomationExecution> automationExecutions) {
        this.setAutomationExecutions(automationExecutions);
        return this;
    }

    public void setChatChannel(ChatChannel chatChannel) {
        this.chatChannel = chatChannel;
    }

    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public IncidentRecord withChatChannel(ChatChannel chatChannel) {
        this.setChatChannel(chatChannel);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public IncidentRecord withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setDedupeString(String dedupeString) {
        this.dedupeString = dedupeString;
    }

    public String getDedupeString() {
        return this.dedupeString;
    }

    public IncidentRecord withDedupeString(String dedupeString) {
        this.setDedupeString(dedupeString);
        return this;
    }

    public void setImpact(Integer impact) {
        this.impact = impact;
    }

    public Integer getImpact() {
        return this.impact;
    }

    public IncidentRecord withImpact(Integer impact) {
        this.setImpact(impact);
        return this;
    }

    public void setIncidentRecordSource(IncidentRecordSource incidentRecordSource) {
        this.incidentRecordSource = incidentRecordSource;
    }

    public IncidentRecordSource getIncidentRecordSource() {
        return this.incidentRecordSource;
    }

    public IncidentRecord withIncidentRecordSource(IncidentRecordSource incidentRecordSource) {
        this.setIncidentRecordSource(incidentRecordSource);
        return this;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public IncidentRecord withLastModifiedBy(String lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public IncidentRecord withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<NotificationTargetItem> getNotificationTargets() {
        return this.notificationTargets;
    }

    public void setNotificationTargets(Collection<NotificationTargetItem> notificationTargets) {
        if (notificationTargets == null) {
            this.notificationTargets = null;
            return;
        }
        this.notificationTargets = new ArrayList<NotificationTargetItem>(notificationTargets);
    }

    public IncidentRecord withNotificationTargets(NotificationTargetItem ... notificationTargets) {
        if (this.notificationTargets == null) {
            this.setNotificationTargets(new ArrayList<NotificationTargetItem>(notificationTargets.length));
        }
        for (NotificationTargetItem ele : notificationTargets) {
            this.notificationTargets.add(ele);
        }
        return this;
    }

    public IncidentRecord withNotificationTargets(Collection<NotificationTargetItem> notificationTargets) {
        this.setNotificationTargets(notificationTargets);
        return this;
    }

    public void setResolvedTime(Date resolvedTime) {
        this.resolvedTime = resolvedTime;
    }

    public Date getResolvedTime() {
        return this.resolvedTime;
    }

    public IncidentRecord withResolvedTime(Date resolvedTime) {
        this.setResolvedTime(resolvedTime);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public IncidentRecord withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public IncidentRecord withStatus(IncidentRecordStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public IncidentRecord withSummary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public IncidentRecord withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAutomationExecutions() != null) {
            sb.append("AutomationExecutions: ").append(this.getAutomationExecutions()).append(",");
        }
        if (this.getChatChannel() != null) {
            sb.append("ChatChannel: ").append(this.getChatChannel()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getDedupeString() != null) {
            sb.append("DedupeString: ").append(this.getDedupeString()).append(",");
        }
        if (this.getImpact() != null) {
            sb.append("Impact: ").append(this.getImpact()).append(",");
        }
        if (this.getIncidentRecordSource() != null) {
            sb.append("IncidentRecordSource: ").append(this.getIncidentRecordSource()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getNotificationTargets() != null) {
            sb.append("NotificationTargets: ").append(this.getNotificationTargets()).append(",");
        }
        if (this.getResolvedTime() != null) {
            sb.append("ResolvedTime: ").append(this.getResolvedTime()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentRecord)) {
            return false;
        }
        IncidentRecord other = (IncidentRecord)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAutomationExecutions() == null ^ this.getAutomationExecutions() == null) {
            return false;
        }
        if (other.getAutomationExecutions() != null && !other.getAutomationExecutions().equals(this.getAutomationExecutions())) {
            return false;
        }
        if (other.getChatChannel() == null ^ this.getChatChannel() == null) {
            return false;
        }
        if (other.getChatChannel() != null && !other.getChatChannel().equals(this.getChatChannel())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getDedupeString() == null ^ this.getDedupeString() == null) {
            return false;
        }
        if (other.getDedupeString() != null && !other.getDedupeString().equals(this.getDedupeString())) {
            return false;
        }
        if (other.getImpact() == null ^ this.getImpact() == null) {
            return false;
        }
        if (other.getImpact() != null && !other.getImpact().equals(this.getImpact())) {
            return false;
        }
        if (other.getIncidentRecordSource() == null ^ this.getIncidentRecordSource() == null) {
            return false;
        }
        if (other.getIncidentRecordSource() != null && !other.getIncidentRecordSource().equals(this.getIncidentRecordSource())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getNotificationTargets() == null ^ this.getNotificationTargets() == null) {
            return false;
        }
        if (other.getNotificationTargets() != null && !other.getNotificationTargets().equals(this.getNotificationTargets())) {
            return false;
        }
        if (other.getResolvedTime() == null ^ this.getResolvedTime() == null) {
            return false;
        }
        if (other.getResolvedTime() != null && !other.getResolvedTime().equals(this.getResolvedTime())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        return other.getTitle() == null || other.getTitle().equals(this.getTitle());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAutomationExecutions() == null ? 0 : this.getAutomationExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getChatChannel() == null ? 0 : this.getChatChannel().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getDedupeString() == null ? 0 : this.getDedupeString().hashCode());
        hashCode = 31 * hashCode + (this.getImpact() == null ? 0 : this.getImpact().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentRecordSource() == null ? 0 : this.getIncidentRecordSource().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTargets() == null ? 0 : this.getNotificationTargets().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedTime() == null ? 0 : this.getResolvedTime().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        return hashCode;
    }

    public IncidentRecord clone() {
        try {
            return (IncidentRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IncidentRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

