/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ssmsap.AWSSsmSapAsync;
import com.amazonaws.services.ssmsap.AWSSsmSapAsyncClientBuilder;
import com.amazonaws.services.ssmsap.AWSSsmSapClient;
import com.amazonaws.services.ssmsap.model.DeleteResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.DeleteResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.DeregisterApplicationRequest;
import com.amazonaws.services.ssmsap.model.DeregisterApplicationResult;
import com.amazonaws.services.ssmsap.model.GetApplicationRequest;
import com.amazonaws.services.ssmsap.model.GetApplicationResult;
import com.amazonaws.services.ssmsap.model.GetComponentRequest;
import com.amazonaws.services.ssmsap.model.GetComponentResult;
import com.amazonaws.services.ssmsap.model.GetDatabaseRequest;
import com.amazonaws.services.ssmsap.model.GetDatabaseResult;
import com.amazonaws.services.ssmsap.model.GetOperationRequest;
import com.amazonaws.services.ssmsap.model.GetOperationResult;
import com.amazonaws.services.ssmsap.model.GetResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.GetResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.ListApplicationsRequest;
import com.amazonaws.services.ssmsap.model.ListApplicationsResult;
import com.amazonaws.services.ssmsap.model.ListComponentsRequest;
import com.amazonaws.services.ssmsap.model.ListComponentsResult;
import com.amazonaws.services.ssmsap.model.ListDatabasesRequest;
import com.amazonaws.services.ssmsap.model.ListDatabasesResult;
import com.amazonaws.services.ssmsap.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssmsap.model.ListTagsForResourceResult;
import com.amazonaws.services.ssmsap.model.PutResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.PutResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.RegisterApplicationRequest;
import com.amazonaws.services.ssmsap.model.RegisterApplicationResult;
import com.amazonaws.services.ssmsap.model.TagResourceRequest;
import com.amazonaws.services.ssmsap.model.TagResourceResult;
import com.amazonaws.services.ssmsap.model.UntagResourceRequest;
import com.amazonaws.services.ssmsap.model.UntagResourceResult;
import com.amazonaws.services.ssmsap.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.ssmsap.model.UpdateApplicationSettingsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSsmSapAsyncClient
extends AWSSsmSapClient
implements AWSSsmSapAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSsmSapAsyncClientBuilder asyncBuilder() {
        return AWSSsmSapAsyncClientBuilder.standard();
    }

    AWSSsmSapAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSsmSapAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteResourcePermissionResult> deleteResourcePermissionAsync(DeleteResourcePermissionRequest request) {
        return this.deleteResourcePermissionAsync(request, null);
    }

    @Override
    public Future<DeleteResourcePermissionResult> deleteResourcePermissionAsync(DeleteResourcePermissionRequest request, final AsyncHandler<DeleteResourcePermissionRequest, DeleteResourcePermissionResult> asyncHandler) {
        final DeleteResourcePermissionRequest finalRequest = (DeleteResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResourcePermissionResult>(){

            @Override
            public DeleteResourcePermissionResult call() throws Exception {
                DeleteResourcePermissionResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeDeleteResourcePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterApplicationResult> deregisterApplicationAsync(DeregisterApplicationRequest request) {
        return this.deregisterApplicationAsync(request, null);
    }

    @Override
    public Future<DeregisterApplicationResult> deregisterApplicationAsync(DeregisterApplicationRequest request, final AsyncHandler<DeregisterApplicationRequest, DeregisterApplicationResult> asyncHandler) {
        final DeregisterApplicationRequest finalRequest = (DeregisterApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterApplicationResult>(){

            @Override
            public DeregisterApplicationResult call() throws Exception {
                DeregisterApplicationResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeDeregisterApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {
        return this.getApplicationAsync(request, null);
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request, final AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {
        final GetApplicationRequest finalRequest = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetApplicationResult>(){

            @Override
            public GetApplicationResult call() throws Exception {
                GetApplicationResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeGetApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComponentResult> getComponentAsync(GetComponentRequest request) {
        return this.getComponentAsync(request, null);
    }

    @Override
    public Future<GetComponentResult> getComponentAsync(GetComponentRequest request, final AsyncHandler<GetComponentRequest, GetComponentResult> asyncHandler) {
        final GetComponentRequest finalRequest = (GetComponentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComponentResult>(){

            @Override
            public GetComponentResult call() throws Exception {
                GetComponentResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeGetComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request) {
        return this.getDatabaseAsync(request, null);
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request, final AsyncHandler<GetDatabaseRequest, GetDatabaseResult> asyncHandler) {
        final GetDatabaseRequest finalRequest = (GetDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatabaseResult>(){

            @Override
            public GetDatabaseResult call() throws Exception {
                GetDatabaseResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeGetDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request) {
        return this.getOperationAsync(request, null);
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request, final AsyncHandler<GetOperationRequest, GetOperationResult> asyncHandler) {
        final GetOperationRequest finalRequest = (GetOperationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOperationResult>(){

            @Override
            public GetOperationResult call() throws Exception {
                GetOperationResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeGetOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourcePermissionResult> getResourcePermissionAsync(GetResourcePermissionRequest request) {
        return this.getResourcePermissionAsync(request, null);
    }

    @Override
    public Future<GetResourcePermissionResult> getResourcePermissionAsync(GetResourcePermissionRequest request, final AsyncHandler<GetResourcePermissionRequest, GetResourcePermissionResult> asyncHandler) {
        final GetResourcePermissionRequest finalRequest = (GetResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcePermissionResult>(){

            @Override
            public GetResourcePermissionResult call() throws Exception {
                GetResourcePermissionResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeGetResourcePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request) {
        return this.listComponentsAsync(request, null);
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request, final AsyncHandler<ListComponentsRequest, ListComponentsResult> asyncHandler) {
        final ListComponentsRequest finalRequest = (ListComponentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComponentsResult>(){

            @Override
            public ListComponentsResult call() throws Exception {
                ListComponentsResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeListComponents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request) {
        return this.listDatabasesAsync(request, null);
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request, final AsyncHandler<ListDatabasesRequest, ListDatabasesResult> asyncHandler) {
        final ListDatabasesRequest finalRequest = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatabasesResult>(){

            @Override
            public ListDatabasesResult call() throws Exception {
                ListDatabasesResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeListDatabases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutResourcePermissionResult> putResourcePermissionAsync(PutResourcePermissionRequest request) {
        return this.putResourcePermissionAsync(request, null);
    }

    @Override
    public Future<PutResourcePermissionResult> putResourcePermissionAsync(PutResourcePermissionRequest request, final AsyncHandler<PutResourcePermissionRequest, PutResourcePermissionResult> asyncHandler) {
        final PutResourcePermissionRequest finalRequest = (PutResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutResourcePermissionResult>(){

            @Override
            public PutResourcePermissionResult call() throws Exception {
                PutResourcePermissionResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executePutResourcePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterApplicationResult> registerApplicationAsync(RegisterApplicationRequest request) {
        return this.registerApplicationAsync(request, null);
    }

    @Override
    public Future<RegisterApplicationResult> registerApplicationAsync(RegisterApplicationRequest request, final AsyncHandler<RegisterApplicationRequest, RegisterApplicationResult> asyncHandler) {
        final RegisterApplicationRequest finalRequest = (RegisterApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterApplicationResult>(){

            @Override
            public RegisterApplicationResult call() throws Exception {
                RegisterApplicationResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeRegisterApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationSettingsResult> updateApplicationSettingsAsync(UpdateApplicationSettingsRequest request) {
        return this.updateApplicationSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationSettingsResult> updateApplicationSettingsAsync(UpdateApplicationSettingsRequest request, final AsyncHandler<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResult> asyncHandler) {
        final UpdateApplicationSettingsRequest finalRequest = (UpdateApplicationSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationSettingsResult>(){

            @Override
            public UpdateApplicationSettingsResult call() throws Exception {
                UpdateApplicationSettingsResult result = null;
                try {
                    result = AWSSsmSapAsyncClient.this.executeUpdateApplicationSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

