/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmsap.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.ssmsap.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateApplicationSettingsRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateApplicationSettingsRequestMarshaller {

    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").build();
    private static final MarshallingInfo<List> CREDENTIALSTOADDORUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CredentialsToAddOrUpdate").build();
    private static final MarshallingInfo<List> CREDENTIALSTOREMOVE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CredentialsToRemove").build();
    private static final MarshallingInfo<StructuredPojo> BACKINT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Backint").build();
    private static final MarshallingInfo<String> DATABASEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseArn").build();

    private static final UpdateApplicationSettingsRequestMarshaller instance = new UpdateApplicationSettingsRequestMarshaller();

    public static UpdateApplicationSettingsRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateApplicationSettingsRequest updateApplicationSettingsRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateApplicationSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateApplicationSettingsRequest.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(updateApplicationSettingsRequest.getCredentialsToAddOrUpdate(), CREDENTIALSTOADDORUPDATE_BINDING);
            protocolMarshaller.marshall(updateApplicationSettingsRequest.getCredentialsToRemove(), CREDENTIALSTOREMOVE_BINDING);
            protocolMarshaller.marshall(updateApplicationSettingsRequest.getBackint(), BACKINT_BINDING);
            protocolMarshaller.marshall(updateApplicationSettingsRequest.getDatabaseArn(), DATABASEARN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
