/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Web Services Single Sign On Portal is a web service that makes it easy for you to assign user access to Amazon
 * Web Services SSO resources such as the AWS access portal. Users can get Amazon Web Services account applications and
 * roles assigned to them and get federated into the application.
 * </p>
 * <note>
 * <p>
 * Although Amazon Web Services Single Sign-On was renamed, the <code>sso</code> and <code>identitystore</code> API
 * namespaces will continue to retain their original name for backward compatibility purposes. For more information, see
 * <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed">Amazon Web Services SSO
 * rename</a>.
 * </p>
 * </note>
 * <p>
 * This API reference guide describes the Amazon Web Services SSO Portal operations that you can call programatically
 * and includes detailed information on data types and errors.
 * </p>
 * <note>
 * <p>
 * Amazon Web Services provides SDKs that consist of libraries and sample code for various programming languages and
 * platforms, such as Java, Ruby, .Net, iOS, or Android. The SDKs provide a convenient way to create programmatic access
 * to Amazon Web Services SSO and other Amazon Web Services services. For more information about the Amazon Web Services
 * SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web
 * Services</a>.
 * </p>
 * </note>
 */
package com.amazonaws.services.sso;

