/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssooidc.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/CreateToken" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateTokenRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier string for the client or application. This value comes from the result of the
     * <a>RegisterClient</a> API.
     * </p>
     */
    private String clientId;
    /**
     * <p>
     * A secret string generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     */
    private String clientSecret;
    /**
     * <p>
     * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values,
     * depending on the grant type that you want:
     * </p>
     * <p>
     * * Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     * </p>
     * <p>
     * * Refresh Token - <code>refresh_token</code>
     * </p>
     * <p>
     * For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     * </p>
     */
    private String grantType;
    /**
     * <p>
     * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this
     * authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     * </p>
     */
    private String deviceCode;
    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify
     * this authorization request. This grant type is currently unsupported for the <a>CreateToken</a> API.
     * </p>
     */
    private String code;
    /**
     * <p>
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     * tokens, such as the access token, that might expire.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     */
    private String refreshToken;
    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured
     * for the client during the call to <a>RegisterClient</a>.
     * </p>
     */
    private java.util.List<String> scope;
    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the
     * client or application that has registered to receive the authorization code.
     * </p>
     */
    private String redirectUri;

    /**
     * <p>
     * The unique identifier string for the client or application. This value comes from the result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @param clientId
     *        The unique identifier string for the client or application. This value comes from the result of the
     *        <a>RegisterClient</a> API.
     */

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * <p>
     * The unique identifier string for the client or application. This value comes from the result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @return The unique identifier string for the client or application. This value comes from the result of the
     *         <a>RegisterClient</a> API.
     */

    public String getClientId() {
        return this.clientId;
    }

    /**
     * <p>
     * The unique identifier string for the client or application. This value comes from the result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @param clientId
     *        The unique identifier string for the client or application. This value comes from the result of the
     *        <a>RegisterClient</a> API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withClientId(String clientId) {
        setClientId(clientId);
        return this;
    }

    /**
     * <p>
     * A secret string generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @param clientSecret
     *        A secret string generated for the client. This value should come from the persisted result of the
     *        <a>RegisterClient</a> API.
     */

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     * <p>
     * A secret string generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @return A secret string generated for the client. This value should come from the persisted result of the
     *         <a>RegisterClient</a> API.
     */

    public String getClientSecret() {
        return this.clientSecret;
    }

    /**
     * <p>
     * A secret string generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @param clientSecret
     *        A secret string generated for the client. This value should come from the persisted result of the
     *        <a>RegisterClient</a> API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withClientSecret(String clientSecret) {
        setClientSecret(clientSecret);
        return this;
    }

    /**
     * <p>
     * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values,
     * depending on the grant type that you want:
     * </p>
     * <p>
     * * Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     * </p>
     * <p>
     * * Refresh Token - <code>refresh_token</code>
     * </p>
     * <p>
     * For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     * </p>
     * 
     * @param grantType
     *        Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following
     *        values, depending on the grant type that you want:</p>
     *        <p>
     *        Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     *        </p>
     *        <p>
     *        Refresh Token - <code>refresh_token</code>
     *        </p>
     *        <p>
     *        For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     */

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    /**
     * <p>
     * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values,
     * depending on the grant type that you want:
     * </p>
     * <p>
     * * Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     * </p>
     * <p>
     * * Refresh Token - <code>refresh_token</code>
     * </p>
     * <p>
     * For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     * </p>
     * 
     * @return Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following
     *         values, depending on the grant type that you want:</p>
     *         <p>
     *         Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     *         </p>
     *         <p>
     *         Refresh Token - <code>refresh_token</code>
     *         </p>
     *         <p>
     *         For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     */

    public String getGrantType() {
        return this.grantType;
    }

    /**
     * <p>
     * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values,
     * depending on the grant type that you want:
     * </p>
     * <p>
     * * Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     * </p>
     * <p>
     * * Refresh Token - <code>refresh_token</code>
     * </p>
     * <p>
     * For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     * </p>
     * 
     * @param grantType
     *        Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following
     *        values, depending on the grant type that you want:</p>
     *        <p>
     *        Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code>
     *        </p>
     *        <p>
     *        Refresh Token - <code>refresh_token</code>
     *        </p>
     *        <p>
     *        For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withGrantType(String grantType) {
        setGrantType(grantType);
        return this;
    }

    /**
     * <p>
     * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this
     * authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     * </p>
     * 
     * @param deviceCode
     *        Used only when calling this API for the Device Code grant type. This short-term code is used to identify
     *        this authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     */

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    /**
     * <p>
     * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this
     * authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     * </p>
     * 
     * @return Used only when calling this API for the Device Code grant type. This short-term code is used to identify
     *         this authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     */

    public String getDeviceCode() {
        return this.deviceCode;
    }

    /**
     * <p>
     * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this
     * authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     * </p>
     * 
     * @param deviceCode
     *        Used only when calling this API for the Device Code grant type. This short-term code is used to identify
     *        this authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withDeviceCode(String deviceCode) {
        setDeviceCode(deviceCode);
        return this;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify
     * this authorization request. This grant type is currently unsupported for the <a>CreateToken</a> API.
     * </p>
     * 
     * @param code
     *        Used only when calling this API for the Authorization Code grant type. The short-term code is used to
     *        identify this authorization request. This grant type is currently unsupported for the <a>CreateToken</a>
     *        API.
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify
     * this authorization request. This grant type is currently unsupported for the <a>CreateToken</a> API.
     * </p>
     * 
     * @return Used only when calling this API for the Authorization Code grant type. The short-term code is used to
     *         identify this authorization request. This grant type is currently unsupported for the <a>CreateToken</a>
     *         API.
     */

    public String getCode() {
        return this.code;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify
     * this authorization request. This grant type is currently unsupported for the <a>CreateToken</a> API.
     * </p>
     * 
     * @param code
     *        Used only when calling this API for the Authorization Code grant type. The short-term code is used to
     *        identify this authorization request. This grant type is currently unsupported for the <a>CreateToken</a>
     *        API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * <p>
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     * tokens, such as the access token, that might expire.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     * 
     * @param refreshToken
     *        Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     *        tokens, such as the access token, that might expire.</p>
     *        <p>
     *        For more information about the features and limitations of the current IAM Identity Center OIDC
     *        implementation, see <i>Considerations for Using this Guide</i> in the <a
     *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *        OIDC API Reference</a>.
     */

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    /**
     * <p>
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     * tokens, such as the access token, that might expire.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     * 
     * @return Used only when calling this API for the Refresh Token grant type. This token is used to refresh
     *         short-term tokens, such as the access token, that might expire.</p>
     *         <p>
     *         For more information about the features and limitations of the current IAM Identity Center OIDC
     *         implementation, see <i>Considerations for Using this Guide</i> in the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.
     */

    public String getRefreshToken() {
        return this.refreshToken;
    }

    /**
     * <p>
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     * tokens, such as the access token, that might expire.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     * 
     * @param refreshToken
     *        Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     *        tokens, such as the access token, that might expire.</p>
     *        <p>
     *        For more information about the features and limitations of the current IAM Identity Center OIDC
     *        implementation, see <i>Considerations for Using this Guide</i> in the <a
     *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *        OIDC API Reference</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withRefreshToken(String refreshToken) {
        setRefreshToken(refreshToken);
        return this;
    }

    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured
     * for the client during the call to <a>RegisterClient</a>.
     * </p>
     * 
     * @return The list of scopes for which authorization is requested. The access token that is issued is limited to
     *         the scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes
     *         that are configured for the client during the call to <a>RegisterClient</a>.
     */

    public java.util.List<String> getScope() {
        return scope;
    }

    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured
     * for the client during the call to <a>RegisterClient</a>.
     * </p>
     * 
     * @param scope
     *        The list of scopes for which authorization is requested. The access token that is issued is limited to the
     *        scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that
     *        are configured for the client during the call to <a>RegisterClient</a>.
     */

    public void setScope(java.util.Collection<String> scope) {
        if (scope == null) {
            this.scope = null;
            return;
        }

        this.scope = new java.util.ArrayList<String>(scope);
    }

    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured
     * for the client during the call to <a>RegisterClient</a>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setScope(java.util.Collection)} or {@link #withScope(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param scope
     *        The list of scopes for which authorization is requested. The access token that is issued is limited to the
     *        scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that
     *        are configured for the client during the call to <a>RegisterClient</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withScope(String... scope) {
        if (this.scope == null) {
            setScope(new java.util.ArrayList<String>(scope.length));
        }
        for (String ele : scope) {
            this.scope.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured
     * for the client during the call to <a>RegisterClient</a>.
     * </p>
     * 
     * @param scope
     *        The list of scopes for which authorization is requested. The access token that is issued is limited to the
     *        scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that
     *        are configured for the client during the call to <a>RegisterClient</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withScope(java.util.Collection<String> scope) {
        setScope(scope);
        return this;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the
     * client or application that has registered to receive the authorization code.
     * </p>
     * 
     * @param redirectUri
     *        Used only when calling this API for the Authorization Code grant type. This value specifies the location
     *        of the client or application that has registered to receive the authorization code.
     */

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the
     * client or application that has registered to receive the authorization code.
     * </p>
     * 
     * @return Used only when calling this API for the Authorization Code grant type. This value specifies the location
     *         of the client or application that has registered to receive the authorization code.
     */

    public String getRedirectUri() {
        return this.redirectUri;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the
     * client or application that has registered to receive the authorization code.
     * </p>
     * 
     * @param redirectUri
     *        Used only when calling this API for the Authorization Code grant type. This value specifies the location
     *        of the client or application that has registered to receive the authorization code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateTokenRequest withRedirectUri(String redirectUri) {
        setRedirectUri(redirectUri);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientId() != null)
            sb.append("ClientId: ").append(getClientId()).append(",");
        if (getClientSecret() != null)
            sb.append("ClientSecret: ").append("***Sensitive Data Redacted***").append(",");
        if (getGrantType() != null)
            sb.append("GrantType: ").append(getGrantType()).append(",");
        if (getDeviceCode() != null)
            sb.append("DeviceCode: ").append(getDeviceCode()).append(",");
        if (getCode() != null)
            sb.append("Code: ").append(getCode()).append(",");
        if (getRefreshToken() != null)
            sb.append("RefreshToken: ").append("***Sensitive Data Redacted***").append(",");
        if (getScope() != null)
            sb.append("Scope: ").append(getScope()).append(",");
        if (getRedirectUri() != null)
            sb.append("RedirectUri: ").append(getRedirectUri());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateTokenRequest == false)
            return false;
        CreateTokenRequest other = (CreateTokenRequest) obj;
        if (other.getClientId() == null ^ this.getClientId() == null)
            return false;
        if (other.getClientId() != null && other.getClientId().equals(this.getClientId()) == false)
            return false;
        if (other.getClientSecret() == null ^ this.getClientSecret() == null)
            return false;
        if (other.getClientSecret() != null && other.getClientSecret().equals(this.getClientSecret()) == false)
            return false;
        if (other.getGrantType() == null ^ this.getGrantType() == null)
            return false;
        if (other.getGrantType() != null && other.getGrantType().equals(this.getGrantType()) == false)
            return false;
        if (other.getDeviceCode() == null ^ this.getDeviceCode() == null)
            return false;
        if (other.getDeviceCode() != null && other.getDeviceCode().equals(this.getDeviceCode()) == false)
            return false;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        if (other.getRefreshToken() == null ^ this.getRefreshToken() == null)
            return false;
        if (other.getRefreshToken() != null && other.getRefreshToken().equals(this.getRefreshToken()) == false)
            return false;
        if (other.getScope() == null ^ this.getScope() == null)
            return false;
        if (other.getScope() != null && other.getScope().equals(this.getScope()) == false)
            return false;
        if (other.getRedirectUri() == null ^ this.getRedirectUri() == null)
            return false;
        if (other.getRedirectUri() != null && other.getRedirectUri().equals(this.getRedirectUri()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientId() == null) ? 0 : getClientId().hashCode());
        hashCode = prime * hashCode + ((getClientSecret() == null) ? 0 : getClientSecret().hashCode());
        hashCode = prime * hashCode + ((getGrantType() == null) ? 0 : getGrantType().hashCode());
        hashCode = prime * hashCode + ((getDeviceCode() == null) ? 0 : getDeviceCode().hashCode());
        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        hashCode = prime * hashCode + ((getRefreshToken() == null) ? 0 : getRefreshToken().hashCode());
        hashCode = prime * hashCode + ((getScope() == null) ? 0 : getScope().hashCode());
        hashCode = prime * hashCode + ((getRedirectUri() == null) ? 0 : getRedirectUri().hashCode());
        return hashCode;
    }

    @Override
    public CreateTokenRequest clone() {
        return (CreateTokenRequest) super.clone();
    }

}
