/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.Branch;
import com.amazonaws.services.stepfunctions.builder.states.Catcher;
import com.amazonaws.services.stepfunctions.builder.states.Retrier;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.TransitionStateBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.List;

public final class ParallelState
extends TransitionState {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="Branches")
    private final List<Branch> branches;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="ResultPath")
    private final String resultPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;
    @JsonUnwrapped
    private final Transition transition;
    @JsonProperty(value="Retry")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Retrier> retriers;
    @JsonProperty(value="Catch")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Catcher> catchers;

    private ParallelState(Builder builder) {
        this.comment = builder.comment;
        this.branches = Buildable.Utils.build(builder.branches);
        this.inputPath = builder.inputPath;
        this.resultPath = builder.resultPath;
        this.outputPath = builder.outputPath;
        this.transition = (Transition)builder.transition.build();
        this.retriers = Buildable.Utils.build(builder.retriers);
        this.catchers = Buildable.Utils.build(builder.catchers);
    }

    @Override
    public String getType() {
        return "Parallel";
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public List<Retrier> getRetriers() {
        return this.retriers;
    }

    public List<Catcher> getCatchers() {
        return this.catchers;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TransitionStateBuilder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="Branches")
        private List<Branch.Builder> branches = new ArrayList<Branch.Builder>();
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="ResultPath")
        private String resultPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;
        private Transition.Builder transition = Transition.NULL_BUILDER;
        @JsonProperty(value="Retry")
        private List<Retrier.Builder> retriers = new ArrayList<Retrier.Builder>();
        @JsonProperty(value="Catch")
        private List<Catcher.Builder> catchers = new ArrayList<Catcher.Builder>();

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder branch(Branch.Builder branchBuilder) {
            this.branches.add(branchBuilder);
            return this;
        }

        public Builder branches(Branch.Builder ... branchBuilders) {
            for (Branch.Builder branchBuilder : branchBuilders) {
                this.branch(branchBuilder);
            }
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        @Override
        public Builder transition(Transition.Builder builder) {
            this.transition = builder;
            return this;
        }

        public Builder retriers(Retrier.Builder ... retrierBuilders) {
            for (Retrier.Builder retrierBuilder : retrierBuilders) {
                this.retrier(retrierBuilder);
            }
            return this;
        }

        public Builder retrier(Retrier.Builder retrierBuilder) {
            this.retriers.add(retrierBuilder);
            return this;
        }

        public Builder catchers(Catcher.Builder ... catcherBuilders) {
            for (Catcher.Builder catcherBuilder : catcherBuilders) {
                this.catcher(catcherBuilder);
            }
            return this;
        }

        public Builder catcher(Catcher.Builder catcherBuilder) {
            this.catchers.add(catcherBuilder);
            return this;
        }

        @Override
        public ParallelState build() {
            return new ParallelState(this);
        }
    }
}

