/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.Catcher;
import com.amazonaws.services.stepfunctions.builder.states.Retrier;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.TransitionStateBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.List;

public final class TaskState
extends TransitionState {
    @JsonProperty(value="Resource")
    private final String resource;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="ResultPath")
    private final String resultPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="TimeoutSeconds")
    private final Integer timeoutSeconds;
    @JsonProperty(value="HeartbeatSeconds")
    private final Integer heartbeatSeconds;
    @JsonUnwrapped
    private final Transition transition;
    @JsonProperty(value="Retry")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Retrier> retriers;
    @JsonProperty(value="Catch")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Catcher> catchers;

    private TaskState(Builder builder) {
        this.resource = builder.resource;
        this.inputPath = builder.inputPath;
        this.resultPath = builder.resultPath;
        this.outputPath = builder.outputPath;
        this.comment = builder.comment;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.heartbeatSeconds = builder.heartbeatSeconds;
        this.transition = (Transition)builder.transition.build();
        this.retriers = Buildable.Utils.build(builder.retriers);
        this.catchers = Buildable.Utils.build(builder.catchers);
    }

    @Override
    public String getType() {
        return "Task";
    }

    public String getResource() {
        return this.resource;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    public String getComment() {
        return this.comment;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Integer getHeartbeatSeconds() {
        return this.heartbeatSeconds;
    }

    public List<Retrier> getRetriers() {
        return this.retriers;
    }

    public List<Catcher> getCatchers() {
        return this.catchers;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TransitionStateBuilder {
        @JsonProperty(value="Resource")
        private String resource;
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="ResultPath")
        private String resultPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="TimeoutSeconds")
        private Integer timeoutSeconds;
        @JsonProperty(value="HeartbeatSeconds")
        private Integer heartbeatSeconds;
        private Transition.Builder transition = Transition.NULL_BUILDER;
        @JsonProperty(value="Retry")
        private final List<Retrier.Builder> retriers = new ArrayList<Retrier.Builder>();
        @JsonProperty(value="Catch")
        private final List<Catcher.Builder> catchers = new ArrayList<Catcher.Builder>();

        private Builder() {
        }

        public Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder heartbeatSeconds(Integer heartbeatSeconds) {
            this.heartbeatSeconds = heartbeatSeconds;
            return this;
        }

        @Override
        public Builder transition(Transition.Builder transition) {
            this.transition = transition;
            return this;
        }

        public Builder retriers(Retrier.Builder ... retrierBuilders) {
            for (Retrier.Builder retrierBuilder : retrierBuilders) {
                this.retrier(retrierBuilder);
            }
            return this;
        }

        public Builder retrier(Retrier.Builder retrierBuilder) {
            this.retriers.add(retrierBuilder);
            return this;
        }

        public Builder catchers(Catcher.Builder ... catcherBuilders) {
            for (Catcher.Builder catcherBuilder : catcherBuilders) {
                this.catcher(catcherBuilder);
            }
            return this;
        }

        public Builder catcher(Catcher.Builder catcherBuilder) {
            this.catchers.add(catcherBuilder);
            return this;
        }

        @Override
        public TaskState build() {
            return new TaskState(this);
        }
    }
}

