/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetExecutionHistoryRequestMarshaller
implements Marshaller<Request<GetExecutionHistoryRequest>, GetExecutionHistoryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetExecutionHistoryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetExecutionHistoryRequest> marshall(GetExecutionHistoryRequest getExecutionHistoryRequest) {
        if (getExecutionHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getExecutionHistoryRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.GetExecutionHistory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getExecutionHistoryRequest.getExecutionArn() != null) {
                jsonGenerator.writeFieldName("executionArn").writeValue(getExecutionHistoryRequest.getExecutionArn());
            }
            if (getExecutionHistoryRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(getExecutionHistoryRequest.getMaxResults().intValue());
            }
            if (getExecutionHistoryRequest.getReverseOrder() != null) {
                jsonGenerator.writeFieldName("reverseOrder").writeValue(getExecutionHistoryRequest.getReverseOrder().booleanValue());
            }
            if (getExecutionHistoryRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(getExecutionHistoryRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

