/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SendTaskSuccessRequestMarshaller
implements Marshaller<Request<SendTaskSuccessRequest>, SendTaskSuccessRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SendTaskSuccessRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SendTaskSuccessRequest> marshall(SendTaskSuccessRequest sendTaskSuccessRequest) {
        if (sendTaskSuccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendTaskSuccessRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.SendTaskSuccess");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (sendTaskSuccessRequest.getTaskToken() != null) {
                jsonGenerator.writeFieldName("taskToken").writeValue(sendTaskSuccessRequest.getTaskToken());
            }
            if (sendTaskSuccessRequest.getOutput() != null) {
                jsonGenerator.writeFieldName("output").writeValue(sendTaskSuccessRequest.getOutput());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

