/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.stepfunctions.AWSStepFunctions;
import com.amazonaws.services.stepfunctions.model.AWSStepFunctionsException;
import com.amazonaws.services.stepfunctions.model.ActivityDoesNotExistException;
import com.amazonaws.services.stepfunctions.model.ActivityLimitExceededException;
import com.amazonaws.services.stepfunctions.model.ActivityWorkerLimitExceededException;
import com.amazonaws.services.stepfunctions.model.CreateActivityRequest;
import com.amazonaws.services.stepfunctions.model.CreateActivityResult;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DeleteActivityRequest;
import com.amazonaws.services.stepfunctions.model.DeleteActivityResult;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DescribeActivityRequest;
import com.amazonaws.services.stepfunctions.model.DescribeActivityResult;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionRequest;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionResult;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineResult;
import com.amazonaws.services.stepfunctions.model.ExecutionAlreadyExistsException;
import com.amazonaws.services.stepfunctions.model.ExecutionDoesNotExistException;
import com.amazonaws.services.stepfunctions.model.ExecutionLimitExceededException;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskRequest;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskResult;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryRequest;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryResult;
import com.amazonaws.services.stepfunctions.model.InvalidArnException;
import com.amazonaws.services.stepfunctions.model.InvalidDefinitionException;
import com.amazonaws.services.stepfunctions.model.InvalidExecutionInputException;
import com.amazonaws.services.stepfunctions.model.InvalidNameException;
import com.amazonaws.services.stepfunctions.model.InvalidOutputException;
import com.amazonaws.services.stepfunctions.model.InvalidTokenException;
import com.amazonaws.services.stepfunctions.model.ListActivitiesRequest;
import com.amazonaws.services.stepfunctions.model.ListActivitiesResult;
import com.amazonaws.services.stepfunctions.model.ListExecutionsRequest;
import com.amazonaws.services.stepfunctions.model.ListExecutionsResult;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesRequest;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesResult;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureResult;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatResult;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessResult;
import com.amazonaws.services.stepfunctions.model.StartExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StartExecutionResult;
import com.amazonaws.services.stepfunctions.model.StateMachineAlreadyExistsException;
import com.amazonaws.services.stepfunctions.model.StateMachineDeletingException;
import com.amazonaws.services.stepfunctions.model.StateMachineDoesNotExistException;
import com.amazonaws.services.stepfunctions.model.StateMachineLimitExceededException;
import com.amazonaws.services.stepfunctions.model.StopExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StopExecutionResult;
import com.amazonaws.services.stepfunctions.model.TaskDoesNotExistException;
import com.amazonaws.services.stepfunctions.model.TaskTimedOutException;
import com.amazonaws.services.stepfunctions.model.transform.CreateActivityRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.CreateActivityResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.CreateStateMachineRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.CreateStateMachineResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DeleteActivityRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DeleteActivityResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DeleteStateMachineRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DeleteStateMachineResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeActivityRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeActivityResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeExecutionRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeExecutionResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeStateMachineRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.DescribeStateMachineResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.GetActivityTaskRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.GetActivityTaskResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.GetExecutionHistoryRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.GetExecutionHistoryResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListActivitiesRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListActivitiesResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListExecutionsRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListStateMachinesRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.ListStateMachinesResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskFailureRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskFailureResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskHeartbeatRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskHeartbeatResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskSuccessRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.SendTaskSuccessResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.StartExecutionRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.StartExecutionResultJsonUnmarshaller;
import com.amazonaws.services.stepfunctions.model.transform.StopExecutionRequestMarshaller;
import com.amazonaws.services.stepfunctions.model.transform.StopExecutionResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSStepFunctionsClient
extends AmazonWebServiceClient
implements AWSStepFunctions {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSStepFunctions.class);
    private static final String DEFAULT_SIGNING_NAME = "states";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActivityDoesNotExist").withModeledClass(ActivityDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StateMachineLimitExceeded").withModeledClass(StateMachineLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidToken").withModeledClass(InvalidTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidDefinition").withModeledClass(InvalidDefinitionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidName").withModeledClass(InvalidNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOutput").withModeledClass(InvalidOutputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActivityLimitExceeded").withModeledClass(ActivityLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StateMachineAlreadyExists").withModeledClass(StateMachineAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExecutionLimitExceeded").withModeledClass(ExecutionLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidExecutionInput").withModeledClass(InvalidExecutionInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArn").withModeledClass(InvalidArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StateMachineDeleting").withModeledClass(StateMachineDeletingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActivityWorkerLimitExceeded").withModeledClass(ActivityWorkerLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TaskDoesNotExist").withModeledClass(TaskDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TaskTimedOut").withModeledClass(TaskTimedOutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExecutionAlreadyExists").withModeledClass(ExecutionAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StateMachineDoesNotExist").withModeledClass(StateMachineDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExecutionDoesNotExist").withModeledClass(ExecutionDoesNotExistException.class)).withBaseServiceExceptionClass(AWSStepFunctionsException.class));

    @Deprecated
    public AWSStepFunctionsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSStepFunctionsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSStepFunctionsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSStepFunctionsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSStepFunctionsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSStepFunctionsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSStepFunctionsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSStepFunctionsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("states.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/stepfunctions/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/stepfunctions/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateActivityResult createActivity(CreateActivityRequest createActivityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createActivityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateActivityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateActivityRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateActivityRequest)super.beforeMarshalling((AmazonWebServiceRequest)createActivityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateActivityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateActivityResult createActivityResult = (CreateActivityResult)response.getAwsResponse();
            return createActivityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStateMachineResult createStateMachine(CreateStateMachineRequest createStateMachineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStateMachineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStateMachineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStateMachineRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateStateMachineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStateMachineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStateMachineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStateMachineResult createStateMachineResult = (CreateStateMachineResult)response.getAwsResponse();
            return createStateMachineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteActivityResult deleteActivity(DeleteActivityRequest deleteActivityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteActivityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteActivityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteActivityRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteActivityRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteActivityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteActivityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteActivityResult deleteActivityResult = (DeleteActivityResult)response.getAwsResponse();
            return deleteActivityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStateMachineResult deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStateMachineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStateMachineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStateMachineRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteStateMachineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStateMachineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStateMachineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStateMachineResult deleteStateMachineResult = (DeleteStateMachineResult)response.getAwsResponse();
            return deleteStateMachineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeActivityResult describeActivity(DescribeActivityRequest describeActivityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeActivityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeActivityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeActivityRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeActivityRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeActivityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeActivityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeActivityResult describeActivityResult = (DescribeActivityResult)response.getAwsResponse();
            return describeActivityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExecutionResult describeExecution(DescribeExecutionRequest describeExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeExecutionRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeExecutionResult describeExecutionResult = (DescribeExecutionResult)response.getAwsResponse();
            return describeExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStateMachineResult describeStateMachine(DescribeStateMachineRequest describeStateMachineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStateMachineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStateMachineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStateMachineRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeStateMachineRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeStateMachineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStateMachineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStateMachineResult describeStateMachineResult = (DescribeStateMachineResult)response.getAwsResponse();
            return describeStateMachineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActivityTaskResult getActivityTask(GetActivityTaskRequest getActivityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getActivityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetActivityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetActivityTaskRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetActivityTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)getActivityTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetActivityTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetActivityTaskResult getActivityTaskResult = (GetActivityTaskResult)response.getAwsResponse();
            return getActivityTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExecutionHistoryResult getExecutionHistory(GetExecutionHistoryRequest getExecutionHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExecutionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExecutionHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExecutionHistoryRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((GetExecutionHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getExecutionHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetExecutionHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExecutionHistoryResult getExecutionHistoryResult = (GetExecutionHistoryResult)response.getAwsResponse();
            return getExecutionHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActivitiesResult listActivities(ListActivitiesRequest listActivitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActivitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActivitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActivitiesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListActivitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listActivitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListActivitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListActivitiesResult listActivitiesResult = (ListActivitiesResult)response.getAwsResponse();
            return listActivitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExecutionsResult listExecutions(ListExecutionsRequest listExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListExecutionsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListExecutionsResult listExecutionsResult = (ListExecutionsResult)response.getAwsResponse();
            return listExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStateMachinesResult listStateMachines(ListStateMachinesRequest listStateMachinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStateMachinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStateMachinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStateMachinesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListStateMachinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStateMachinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStateMachinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStateMachinesResult listStateMachinesResult = (ListStateMachinesResult)response.getAwsResponse();
            return listStateMachinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskFailureResult sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendTaskFailureRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendTaskFailureRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendTaskFailureRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((SendTaskFailureRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendTaskFailureRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendTaskFailureResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendTaskFailureResult sendTaskFailureResult = (SendTaskFailureResult)response.getAwsResponse();
            return sendTaskFailureResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskHeartbeatResult sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendTaskHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendTaskHeartbeatRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendTaskHeartbeatRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((SendTaskHeartbeatRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendTaskHeartbeatRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendTaskHeartbeatResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendTaskHeartbeatResult sendTaskHeartbeatResult = (SendTaskHeartbeatResult)response.getAwsResponse();
            return sendTaskHeartbeatResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTaskSuccessResult sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendTaskSuccessRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendTaskSuccessRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendTaskSuccessRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((SendTaskSuccessRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendTaskSuccessRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendTaskSuccessResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendTaskSuccessResult sendTaskSuccessResult = (SendTaskSuccessResult)response.getAwsResponse();
            return sendTaskSuccessResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExecutionResult startExecution(StartExecutionRequest startExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartExecutionRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((StartExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartExecutionResult startExecutionResult = (StartExecutionResult)response.getAwsResponse();
            return startExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopExecutionResult stopExecution(StopExecutionRequest stopExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopExecutionRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((StopExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopExecutionResult stopExecutionResult = (StopExecutionResult)response.getAwsResponse();
            return stopExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

