/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.stepfunctions.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ListExecutions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListExecutionsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * <p>
     * You can also return a list of executions associated with a specific <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, by
     * specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     */
    private String stateMachineArn;
    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     */
    private String statusFilter;
    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further
     * pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     * </p>
     * <p>
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
     * maximum.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     * <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map Run is
     * returned. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     */
    private String mapRunArn;
    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     */
    private String redriveFilter;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * <p>
     * You can also return a list of executions associated with a specific <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, by
     * specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * 
     * @param stateMachineArn
     *        The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
     *        <p>
     *        You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     *        </p>
     *        <p>
     *        You can also return a list of executions associated with a specific <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or
     *        <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version<
     *        /a>, by specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     */

    public void setStateMachineArn(String stateMachineArn) {
        this.stateMachineArn = stateMachineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * <p>
     * You can also return a list of executions associated with a specific <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, by
     * specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
     *         <p>
     *         You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     *         </p>
     *         <p>
     *         You can also return a list of executions associated with a specific <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>
     *         or <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version
     *         </a>, by specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     */

    public String getStateMachineArn() {
        return this.stateMachineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine whose executions is listed.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * <p>
     * You can also return a list of executions associated with a specific <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, by
     * specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     * </p>
     * 
     * @param stateMachineArn
     *        The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
     *        <p>
     *        You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     *        </p>
     *        <p>
     *        You can also return a list of executions associated with a specific <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or
     *        <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version<
     *        /a>, by specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutionsRequest withStateMachineArn(String stateMachineArn) {
        setStateMachineArn(stateMachineArn);
        return this;
    }

    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     * 
     * @param statusFilter
     *        If specified, only list the executions whose current execution status matches the given filter.
     * @see ExecutionStatus
     */

    public void setStatusFilter(String statusFilter) {
        this.statusFilter = statusFilter;
    }

    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     * 
     * @return If specified, only list the executions whose current execution status matches the given filter.
     * @see ExecutionStatus
     */

    public String getStatusFilter() {
        return this.statusFilter;
    }

    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     * 
     * @param statusFilter
     *        If specified, only list the executions whose current execution status matches the given filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExecutionStatus
     */

    public ListExecutionsRequest withStatusFilter(String statusFilter) {
        setStatusFilter(statusFilter);
        return this;
    }

    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     * 
     * @param statusFilter
     *        If specified, only list the executions whose current execution status matches the given filter.
     * @see ExecutionStatus
     */

    public void setStatusFilter(ExecutionStatus statusFilter) {
        withStatusFilter(statusFilter);
    }

    /**
     * <p>
     * If specified, only list the executions whose current execution status matches the given filter.
     * </p>
     * 
     * @param statusFilter
     *        If specified, only list the executions whose current execution status matches the given filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExecutionStatus
     */

    public ListExecutionsRequest withStatusFilter(ExecutionStatus statusFilter) {
        this.statusFilter = statusFilter.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further
     * pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     * </p>
     * <p>
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
     * maximum.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
     *        further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses
     *        the default.</p>
     *        <p>
     *        This is only an upper limit. The actual number of results returned per call might be fewer than the
     *        specified maximum.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further
     * pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     * </p>
     * <p>
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
     * maximum.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
     *         further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses
     *         the default.</p>
     *         <p>
     *         This is only an upper limit. The actual number of results returned per call might be fewer than the
     *         specified maximum.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further
     * pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     * </p>
     * <p>
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified
     * maximum.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain
     *        further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses
     *        the default.</p>
     *        <p>
     *        This is only an upper limit. The actual number of results returned per call might be fewer than the
     *        specified maximum.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutionsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @param nextToken
     *        If <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *        token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *        24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken</i> error.
     * </p>
     * 
     * @param nextToken
     *        If <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *        token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *        24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutionsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     * <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map Run is
     * returned. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * 
     * @param mapRunArn
     *        The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     *        <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map
     *        Run is returned. For more information, see <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map
     *        Run</a> in the <i>Step Functions Developer Guide</i>.</p>
     *        <p>
     *        You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     */

    public void setMapRunArn(String mapRunArn) {
        this.mapRunArn = mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     * <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map Run is
     * returned. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     *         <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a
     *         Map Run is returned. For more information, see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map
     *         Run</a> in the <i>Step Functions Developer Guide</i>.</p>
     *         <p>
     *         You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     */

    public String getMapRunArn() {
        return this.mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     * <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map Run is
     * returned. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a>
     * in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * </p>
     * 
     * @param mapRunArn
     *        The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the
     *        <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map
     *        Run is returned. For more information, see <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map
     *        Run</a> in the <i>Step Functions Developer Guide</i>.</p>
     *        <p>
     *        You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutionsRequest withMapRunArn(String mapRunArn) {
        setMapRunArn(mapRunArn);
        return this;
    }

    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     * 
     * @param redriveFilter
     *        Sets a filter to list executions based on whether or not they have been redriven.</p>
     *        <p>
     *        For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     *        whether or not they have been redriven.
     *        </p>
     *        <p>
     *        If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     *        non-redriven executions.
     *        </p>
     *        <p>
     *        If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * @see ExecutionRedriveFilter
     */

    public void setRedriveFilter(String redriveFilter) {
        this.redriveFilter = redriveFilter;
    }

    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     * 
     * @return Sets a filter to list executions based on whether or not they have been redriven.</p>
     *         <p>
     *         For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based
     *         on whether or not they have been redriven.
     *         </p>
     *         <p>
     *         If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     *         non-redriven executions.
     *         </p>
     *         <p>
     *         If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * @see ExecutionRedriveFilter
     */

    public String getRedriveFilter() {
        return this.redriveFilter;
    }

    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     * 
     * @param redriveFilter
     *        Sets a filter to list executions based on whether or not they have been redriven.</p>
     *        <p>
     *        For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     *        whether or not they have been redriven.
     *        </p>
     *        <p>
     *        If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     *        non-redriven executions.
     *        </p>
     *        <p>
     *        If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExecutionRedriveFilter
     */

    public ListExecutionsRequest withRedriveFilter(String redriveFilter) {
        setRedriveFilter(redriveFilter);
        return this;
    }

    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     * 
     * @param redriveFilter
     *        Sets a filter to list executions based on whether or not they have been redriven.</p>
     *        <p>
     *        For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     *        whether or not they have been redriven.
     *        </p>
     *        <p>
     *        If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     *        non-redriven executions.
     *        </p>
     *        <p>
     *        If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * @see ExecutionRedriveFilter
     */

    public void setRedriveFilter(ExecutionRedriveFilter redriveFilter) {
        withRedriveFilter(redriveFilter);
    }

    /**
     * <p>
     * Sets a filter to list executions based on whether or not they have been redriven.
     * </p>
     * <p>
     * For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     * whether or not they have been redriven.
     * </p>
     * <p>
     * If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     * non-redriven executions.
     * </p>
     * <p>
     * If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * </p>
     * 
     * @param redriveFilter
     *        Sets a filter to list executions based on whether or not they have been redriven.</p>
     *        <p>
     *        For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on
     *        whether or not they have been redriven.
     *        </p>
     *        <p>
     *        If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and
     *        non-redriven executions.
     *        </p>
     *        <p>
     *        If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExecutionRedriveFilter
     */

    public ListExecutionsRequest withRedriveFilter(ExecutionRedriveFilter redriveFilter) {
        this.redriveFilter = redriveFilter.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStateMachineArn() != null)
            sb.append("StateMachineArn: ").append(getStateMachineArn()).append(",");
        if (getStatusFilter() != null)
            sb.append("StatusFilter: ").append(getStatusFilter()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMapRunArn() != null)
            sb.append("MapRunArn: ").append(getMapRunArn()).append(",");
        if (getRedriveFilter() != null)
            sb.append("RedriveFilter: ").append(getRedriveFilter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListExecutionsRequest == false)
            return false;
        ListExecutionsRequest other = (ListExecutionsRequest) obj;
        if (other.getStateMachineArn() == null ^ this.getStateMachineArn() == null)
            return false;
        if (other.getStateMachineArn() != null && other.getStateMachineArn().equals(this.getStateMachineArn()) == false)
            return false;
        if (other.getStatusFilter() == null ^ this.getStatusFilter() == null)
            return false;
        if (other.getStatusFilter() != null && other.getStatusFilter().equals(this.getStatusFilter()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMapRunArn() == null ^ this.getMapRunArn() == null)
            return false;
        if (other.getMapRunArn() != null && other.getMapRunArn().equals(this.getMapRunArn()) == false)
            return false;
        if (other.getRedriveFilter() == null ^ this.getRedriveFilter() == null)
            return false;
        if (other.getRedriveFilter() != null && other.getRedriveFilter().equals(this.getRedriveFilter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStateMachineArn() == null) ? 0 : getStateMachineArn().hashCode());
        hashCode = prime * hashCode + ((getStatusFilter() == null) ? 0 : getStatusFilter().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMapRunArn() == null) ? 0 : getMapRunArn().hashCode());
        hashCode = prime * hashCode + ((getRedriveFilter() == null) ? 0 : getRedriveFilter().hashCode());
        return hashCode;
    }

    @Override
    public ListExecutionsRequest clone() {
        return (ListExecutionsRequest) super.clone();
    }

}
