/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.stepfunctions.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachineForExecution"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeStateMachineForExecutionResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * </p>
     */
    private String stateMachineArn;
    /**
     * <p>
     * The name of the state machine associated with the execution.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     */
    private String definition;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * </p>
     */
    private String roleArn;
    /**
     * <p>
     * The date and time the state machine associated with an execution was updated. For a newly created state machine,
     * this is the creation date.
     * </p>
     */
    private java.util.Date updateDate;

    private LoggingConfiguration loggingConfiguration;
    /**
     * <p>
     * Selects whether X-Ray tracing is enabled.
     * </p>
     */
    private TracingConfiguration tracingConfiguration;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned
     * only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     */
    private String mapRunArn;
    /**
     * <p>
     * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned only
     * if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     */
    private String label;
    /**
     * <p>
     * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
     * </p>
     * <p>
     * Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with the
     * configuration of the state machine used for executions without performing a diff of the properties, such as
     * <code>definition</code> and <code>roleArn</code>.
     * </p>
     */
    private String revisionId;
    /**
     * <p>
     * Settings to configure server-side encryption.
     * </p>
     */
    private EncryptionConfiguration encryptionConfiguration;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * </p>
     * 
     * @param stateMachineArn
     *        The Amazon Resource Name (ARN) of the state machine associated with the execution.
     */

    public void setStateMachineArn(String stateMachineArn) {
        this.stateMachineArn = stateMachineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine associated with the execution.
     */

    public String getStateMachineArn() {
        return this.stateMachineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * </p>
     * 
     * @param stateMachineArn
     *        The Amazon Resource Name (ARN) of the state machine associated with the execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withStateMachineArn(String stateMachineArn) {
        setStateMachineArn(stateMachineArn);
        return this;
    }

    /**
     * <p>
     * The name of the state machine associated with the execution.
     * </p>
     * 
     * @param name
     *        The name of the state machine associated with the execution.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the state machine associated with the execution.
     * </p>
     * 
     * @return The name of the state machine associated with the execution.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the state machine associated with the execution.
     * </p>
     * 
     * @param name
     *        The name of the state machine associated with the execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @param definition
     *        The Amazon States Language definition of the state machine. See <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *        States Language</a>.
     */

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine. See <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a>.
     */

    public String getDefinition() {
        return this.definition;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @param definition
     *        The Amazon States Language definition of the state machine. See <a
     *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *        States Language</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withDefinition(String definition) {
        setDefinition(definition);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * <p>
     * The date and time the state machine associated with an execution was updated. For a newly created state machine,
     * this is the creation date.
     * </p>
     * 
     * @param updateDate
     *        The date and time the state machine associated with an execution was updated. For a newly created state
     *        machine, this is the creation date.
     */

    public void setUpdateDate(java.util.Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * <p>
     * The date and time the state machine associated with an execution was updated. For a newly created state machine,
     * this is the creation date.
     * </p>
     * 
     * @return The date and time the state machine associated with an execution was updated. For a newly created state
     *         machine, this is the creation date.
     */

    public java.util.Date getUpdateDate() {
        return this.updateDate;
    }

    /**
     * <p>
     * The date and time the state machine associated with an execution was updated. For a newly created state machine,
     * this is the creation date.
     * </p>
     * 
     * @param updateDate
     *        The date and time the state machine associated with an execution was updated. For a newly created state
     *        machine, this is the creation date.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withUpdateDate(java.util.Date updateDate) {
        setUpdateDate(updateDate);
        return this;
    }

    /**
     * @param loggingConfiguration
     */

    public void setLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
        this.loggingConfiguration = loggingConfiguration;
    }

    /**
     * @return
     */

    public LoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfiguration;
    }

    /**
     * @param loggingConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
        setLoggingConfiguration(loggingConfiguration);
        return this;
    }

    /**
     * <p>
     * Selects whether X-Ray tracing is enabled.
     * </p>
     * 
     * @param tracingConfiguration
     *        Selects whether X-Ray tracing is enabled.
     */

    public void setTracingConfiguration(TracingConfiguration tracingConfiguration) {
        this.tracingConfiguration = tracingConfiguration;
    }

    /**
     * <p>
     * Selects whether X-Ray tracing is enabled.
     * </p>
     * 
     * @return Selects whether X-Ray tracing is enabled.
     */

    public TracingConfiguration getTracingConfiguration() {
        return this.tracingConfiguration;
    }

    /**
     * <p>
     * Selects whether X-Ray tracing is enabled.
     * </p>
     * 
     * @param tracingConfiguration
     *        Selects whether X-Ray tracing is enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withTracingConfiguration(TracingConfiguration tracingConfiguration) {
        setTracingConfiguration(tracingConfiguration);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned
     * only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @param mapRunArn
     *        The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is
     *        returned only if the <code>executionArn</code> is a child workflow execution that was started by a
     *        Distributed Map state.
     */

    public void setMapRunArn(String mapRunArn) {
        this.mapRunArn = mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned
     * only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is
     *         returned only if the <code>executionArn</code> is a child workflow execution that was started by a
     *         Distributed Map state.
     */

    public String getMapRunArn() {
        return this.mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned
     * only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @param mapRunArn
     *        The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is
     *        returned only if the <code>executionArn</code> is a child workflow execution that was started by a
     *        Distributed Map state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withMapRunArn(String mapRunArn) {
        setMapRunArn(mapRunArn);
        return this;
    }

    /**
     * <p>
     * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned only
     * if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @param label
     *        A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned
     *        only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map
     *        state.
     */

    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * <p>
     * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned only
     * if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @return A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is
     *         returned only if the <code>executionArn</code> is a child workflow execution that was started by a
     *         Distributed Map state.
     */

    public String getLabel() {
        return this.label;
    }

    /**
     * <p>
     * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned only
     * if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.
     * </p>
     * 
     * @param label
     *        A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned
     *        only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map
     *        state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withLabel(String label) {
        setLabel(label);
        return this;
    }

    /**
     * <p>
     * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
     * </p>
     * <p>
     * Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with the
     * configuration of the state machine used for executions without performing a diff of the properties, such as
     * <code>definition</code> and <code>roleArn</code>.
     * </p>
     * 
     * @param revisionId
     *        The revision identifier for the state machine. The first revision ID when you create the state machine is
     *        null.</p>
     *        <p>
     *        Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with
     *        the configuration of the state machine used for executions without performing a diff of the properties,
     *        such as <code>definition</code> and <code>roleArn</code>.
     */

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    /**
     * <p>
     * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
     * </p>
     * <p>
     * Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with the
     * configuration of the state machine used for executions without performing a diff of the properties, such as
     * <code>definition</code> and <code>roleArn</code>.
     * </p>
     * 
     * @return The revision identifier for the state machine. The first revision ID when you create the state machine is
     *         null.</p>
     *         <p>
     *         Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with
     *         the configuration of the state machine used for executions without performing a diff of the properties,
     *         such as <code>definition</code> and <code>roleArn</code>.
     */

    public String getRevisionId() {
        return this.revisionId;
    }

    /**
     * <p>
     * The revision identifier for the state machine. The first revision ID when you create the state machine is null.
     * </p>
     * <p>
     * Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with the
     * configuration of the state machine used for executions without performing a diff of the properties, such as
     * <code>definition</code> and <code>roleArn</code>.
     * </p>
     * 
     * @param revisionId
     *        The revision identifier for the state machine. The first revision ID when you create the state machine is
     *        null.</p>
     *        <p>
     *        Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with
     *        the configuration of the state machine used for executions without performing a diff of the properties,
     *        such as <code>definition</code> and <code>roleArn</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withRevisionId(String revisionId) {
        setRevisionId(revisionId);
        return this;
    }

    /**
     * <p>
     * Settings to configure server-side encryption.
     * </p>
     * 
     * @param encryptionConfiguration
     *        Settings to configure server-side encryption.
     */

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    /**
     * <p>
     * Settings to configure server-side encryption.
     * </p>
     * 
     * @return Settings to configure server-side encryption.
     */

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    /**
     * <p>
     * Settings to configure server-side encryption.
     * </p>
     * 
     * @param encryptionConfiguration
     *        Settings to configure server-side encryption.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeStateMachineForExecutionResult withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStateMachineArn() != null)
            sb.append("StateMachineArn: ").append(getStateMachineArn()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDefinition() != null)
            sb.append("Definition: ").append("***Sensitive Data Redacted***").append(",");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn()).append(",");
        if (getUpdateDate() != null)
            sb.append("UpdateDate: ").append(getUpdateDate()).append(",");
        if (getLoggingConfiguration() != null)
            sb.append("LoggingConfiguration: ").append(getLoggingConfiguration()).append(",");
        if (getTracingConfiguration() != null)
            sb.append("TracingConfiguration: ").append(getTracingConfiguration()).append(",");
        if (getMapRunArn() != null)
            sb.append("MapRunArn: ").append(getMapRunArn()).append(",");
        if (getLabel() != null)
            sb.append("Label: ").append(getLabel()).append(",");
        if (getRevisionId() != null)
            sb.append("RevisionId: ").append(getRevisionId()).append(",");
        if (getEncryptionConfiguration() != null)
            sb.append("EncryptionConfiguration: ").append(getEncryptionConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeStateMachineForExecutionResult == false)
            return false;
        DescribeStateMachineForExecutionResult other = (DescribeStateMachineForExecutionResult) obj;
        if (other.getStateMachineArn() == null ^ this.getStateMachineArn() == null)
            return false;
        if (other.getStateMachineArn() != null && other.getStateMachineArn().equals(this.getStateMachineArn()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDefinition() == null ^ this.getDefinition() == null)
            return false;
        if (other.getDefinition() != null && other.getDefinition().equals(this.getDefinition()) == false)
            return false;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        if (other.getUpdateDate() == null ^ this.getUpdateDate() == null)
            return false;
        if (other.getUpdateDate() != null && other.getUpdateDate().equals(this.getUpdateDate()) == false)
            return false;
        if (other.getLoggingConfiguration() == null ^ this.getLoggingConfiguration() == null)
            return false;
        if (other.getLoggingConfiguration() != null && other.getLoggingConfiguration().equals(this.getLoggingConfiguration()) == false)
            return false;
        if (other.getTracingConfiguration() == null ^ this.getTracingConfiguration() == null)
            return false;
        if (other.getTracingConfiguration() != null && other.getTracingConfiguration().equals(this.getTracingConfiguration()) == false)
            return false;
        if (other.getMapRunArn() == null ^ this.getMapRunArn() == null)
            return false;
        if (other.getMapRunArn() != null && other.getMapRunArn().equals(this.getMapRunArn()) == false)
            return false;
        if (other.getLabel() == null ^ this.getLabel() == null)
            return false;
        if (other.getLabel() != null && other.getLabel().equals(this.getLabel()) == false)
            return false;
        if (other.getRevisionId() == null ^ this.getRevisionId() == null)
            return false;
        if (other.getRevisionId() != null && other.getRevisionId().equals(this.getRevisionId()) == false)
            return false;
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null)
            return false;
        if (other.getEncryptionConfiguration() != null && other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStateMachineArn() == null) ? 0 : getStateMachineArn().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDefinition() == null) ? 0 : getDefinition().hashCode());
        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        hashCode = prime * hashCode + ((getUpdateDate() == null) ? 0 : getUpdateDate().hashCode());
        hashCode = prime * hashCode + ((getLoggingConfiguration() == null) ? 0 : getLoggingConfiguration().hashCode());
        hashCode = prime * hashCode + ((getTracingConfiguration() == null) ? 0 : getTracingConfiguration().hashCode());
        hashCode = prime * hashCode + ((getMapRunArn() == null) ? 0 : getMapRunArn().hashCode());
        hashCode = prime * hashCode + ((getLabel() == null) ? 0 : getLabel().hashCode());
        hashCode = prime * hashCode + ((getRevisionId() == null) ? 0 : getRevisionId().hashCode());
        hashCode = prime * hashCode + ((getEncryptionConfiguration() == null) ? 0 : getEncryptionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public DescribeStateMachineForExecutionResult clone() {
        try {
            return (DescribeStateMachineForExecutionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
