/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeVTLDevicesRequestMarshaller
implements Marshaller<Request<DescribeVTLDevicesRequest>, DescribeVTLDevicesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeVTLDevicesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeVTLDevicesRequest> marshall(DescribeVTLDevicesRequest describeVTLDevicesRequest) {
        if (describeVTLDevicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVTLDevicesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DescribeVTLDevices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList vTLDeviceARNsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeVTLDevicesRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(describeVTLDevicesRequest.getGatewayARN());
            }
            if (!(vTLDeviceARNsList = (SdkInternalList)describeVTLDevicesRequest.getVTLDeviceARNs()).isEmpty() || !vTLDeviceARNsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("VTLDeviceARNs");
                jsonGenerator.writeStartArray();
                for (String vTLDeviceARNsListValue : vTLDeviceARNsList) {
                    if (vTLDeviceARNsListValue == null) continue;
                    jsonGenerator.writeValue(vTLDeviceARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeVTLDevicesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(describeVTLDevicesRequest.getMarker());
            }
            if (describeVTLDevicesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeVTLDevicesRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

