/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.UpdateNFSFileShareRequest;
import com.amazonaws.services.storagegateway.model.transform.NFSFileShareDefaultsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateNFSFileShareRequestMarshaller
implements Marshaller<Request<UpdateNFSFileShareRequest>, UpdateNFSFileShareRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateNFSFileShareRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateNFSFileShareRequest> marshall(UpdateNFSFileShareRequest updateNFSFileShareRequest) {
        if (updateNFSFileShareRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateNFSFileShareRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.UpdateNFSFileShare");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateNFSFileShareRequest.getFileShareARN() != null) {
                jsonGenerator.writeFieldName("FileShareARN").writeValue(updateNFSFileShareRequest.getFileShareARN());
            }
            if (updateNFSFileShareRequest.getKMSEncrypted() != null) {
                jsonGenerator.writeFieldName("KMSEncrypted").writeValue(updateNFSFileShareRequest.getKMSEncrypted().booleanValue());
            }
            if (updateNFSFileShareRequest.getKMSKey() != null) {
                jsonGenerator.writeFieldName("KMSKey").writeValue(updateNFSFileShareRequest.getKMSKey());
            }
            if (updateNFSFileShareRequest.getNFSFileShareDefaults() != null) {
                jsonGenerator.writeFieldName("NFSFileShareDefaults");
                NFSFileShareDefaultsJsonMarshaller.getInstance().marshall(updateNFSFileShareRequest.getNFSFileShareDefaults(), jsonGenerator);
            }
            if (updateNFSFileShareRequest.getDefaultStorageClass() != null) {
                jsonGenerator.writeFieldName("DefaultStorageClass").writeValue(updateNFSFileShareRequest.getDefaultStorageClass());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

