/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.NFSFileShareInfo;
import com.amazonaws.services.storagegateway.model.transform.NFSFileShareDefaultsJsonMarshaller;

public class NFSFileShareInfoJsonMarshaller {
    private static NFSFileShareInfoJsonMarshaller instance;

    public void marshall(NFSFileShareInfo nFSFileShareInfo, StructuredJsonGenerator jsonGenerator) {
        if (nFSFileShareInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList clientListList;
            jsonGenerator.writeStartObject();
            if (nFSFileShareInfo.getNFSFileShareDefaults() != null) {
                jsonGenerator.writeFieldName("NFSFileShareDefaults");
                NFSFileShareDefaultsJsonMarshaller.getInstance().marshall(nFSFileShareInfo.getNFSFileShareDefaults(), jsonGenerator);
            }
            if (nFSFileShareInfo.getFileShareARN() != null) {
                jsonGenerator.writeFieldName("FileShareARN").writeValue(nFSFileShareInfo.getFileShareARN());
            }
            if (nFSFileShareInfo.getFileShareId() != null) {
                jsonGenerator.writeFieldName("FileShareId").writeValue(nFSFileShareInfo.getFileShareId());
            }
            if (nFSFileShareInfo.getFileShareStatus() != null) {
                jsonGenerator.writeFieldName("FileShareStatus").writeValue(nFSFileShareInfo.getFileShareStatus());
            }
            if (nFSFileShareInfo.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(nFSFileShareInfo.getGatewayARN());
            }
            if (nFSFileShareInfo.getKMSEncrypted() != null) {
                jsonGenerator.writeFieldName("KMSEncrypted").writeValue(nFSFileShareInfo.getKMSEncrypted().booleanValue());
            }
            if (nFSFileShareInfo.getKMSKey() != null) {
                jsonGenerator.writeFieldName("KMSKey").writeValue(nFSFileShareInfo.getKMSKey());
            }
            if (nFSFileShareInfo.getPath() != null) {
                jsonGenerator.writeFieldName("Path").writeValue(nFSFileShareInfo.getPath());
            }
            if (nFSFileShareInfo.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(nFSFileShareInfo.getRole());
            }
            if (nFSFileShareInfo.getLocationARN() != null) {
                jsonGenerator.writeFieldName("LocationARN").writeValue(nFSFileShareInfo.getLocationARN());
            }
            if (nFSFileShareInfo.getDefaultStorageClass() != null) {
                jsonGenerator.writeFieldName("DefaultStorageClass").writeValue(nFSFileShareInfo.getDefaultStorageClass());
            }
            if (!(clientListList = (SdkInternalList)nFSFileShareInfo.getClientList()).isEmpty() || !clientListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ClientList");
                jsonGenerator.writeStartArray();
                for (String clientListListValue : clientListList) {
                    if (clientListListValue == null) continue;
                    jsonGenerator.writeValue(clientListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NFSFileShareInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NFSFileShareInfoJsonMarshaller();
        }
        return instance;
    }
}

