/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.storagegateway.model.Tape;
import java.util.Date;

@SdkInternalApi
public class TapeMarshaller {
    private static final MarshallingInfo<String> TAPEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeARN").build();
    private static final MarshallingInfo<String> TAPEBARCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeBarcode").build();
    private static final MarshallingInfo<Date> TAPECREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeCreatedDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> TAPESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeSizeInBytes").build();
    private static final MarshallingInfo<String> TAPESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeStatus").build();
    private static final MarshallingInfo<String> VTLDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VTLDevice").build();
    private static final MarshallingInfo<Double> PROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Progress").build();
    private static final MarshallingInfo<Long> TAPEUSEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeUsedInBytes").build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSKey").build();
    private static final MarshallingInfo<String> POOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PoolId").build();
    private static final MarshallingInfo<Boolean> WORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Worm").build();
    private static final MarshallingInfo<Date> RETENTIONSTARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionStartDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> POOLENTRYDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PoolEntryDate").timestampFormat("unixTimestamp").build();
    private static final TapeMarshaller instance = new TapeMarshaller();

    public static TapeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Tape tape, ProtocolMarshaller protocolMarshaller) {
        if (tape == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tape.getTapeARN(), TAPEARN_BINDING);
            protocolMarshaller.marshall((Object)tape.getTapeBarcode(), TAPEBARCODE_BINDING);
            protocolMarshaller.marshall((Object)tape.getTapeCreatedDate(), TAPECREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)tape.getTapeSizeInBytes(), TAPESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)tape.getTapeStatus(), TAPESTATUS_BINDING);
            protocolMarshaller.marshall((Object)tape.getVTLDevice(), VTLDEVICE_BINDING);
            protocolMarshaller.marshall((Object)tape.getProgress(), PROGRESS_BINDING);
            protocolMarshaller.marshall((Object)tape.getTapeUsedInBytes(), TAPEUSEDINBYTES_BINDING);
            protocolMarshaller.marshall((Object)tape.getKMSKey(), KMSKEY_BINDING);
            protocolMarshaller.marshall((Object)tape.getPoolId(), POOLID_BINDING);
            protocolMarshaller.marshall((Object)tape.getWorm(), WORM_BINDING);
            protocolMarshaller.marshall((Object)tape.getRetentionStartDate(), RETENTIONSTARTDATE_BINDING);
            protocolMarshaller.marshall((Object)tape.getPoolEntryDate(), POOLENTRYDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

