/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.ValidationUtils;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class STSAssumeRoleSessionCredentialsProvider
implements AWSSessionCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 900;
    private static final int EXPIRY_TIME_MILLIS = 60000;
    private final AWSSecurityTokenService securityTokenService;
    private final AtomicReference<Credentials> sessionCredentials = new AtomicReference();
    private final String roleArn;
    private final String roleSessionName;
    private final String roleExternalId;
    private final int roleSessionDurationSeconds;

    public STSAssumeRoleSessionCredentialsProvider(String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName) {
        this(longLivedCredentials, roleArn, roleSessionName, new ClientConfiguration());
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentials(longLivedCredentials).withClientConfiguration(clientConfiguration));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider));
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider).withClientConfiguration(clientConfiguration));
    }

    private STSAssumeRoleSessionCredentialsProvider(Builder builder) {
        if (builder.sts != null) {
            ValidationUtils.assertAllAreNull((String)"If a custom STS client is set you must not set any other client related fields (ClientConfiguration, AWSCredentials, Endpoint, etc", (Object[])new Object[]{builder.longLivedCredentials, builder.longLivedCredentialsProvider, builder.clientConfiguration, builder.serviceEndpoint});
            this.securityTokenService = builder.sts;
        } else {
            this.securityTokenService = STSAssumeRoleSessionCredentialsProvider.buildStsClient(builder);
            if (builder.serviceEndpoint != null) {
                this.securityTokenService.setEndpoint(builder.serviceEndpoint);
            }
        }
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.roleExternalId = builder.roleExternalId;
        this.roleSessionDurationSeconds = builder.roleSessionDurationSeconds != 0 ? builder.roleSessionDurationSeconds : 900;
    }

    private static AWSSecurityTokenService buildStsClient(Builder builder) throws IllegalArgumentException {
        if (builder.longLivedCredentials != null && builder.longLivedCredentialsProvider != null) {
            throw new IllegalArgumentException("It is illegal to set both an AWSCredentials and an AWSCredentialsProvider for an " + STSAssumeRoleSessionCredentialsProvider.class.getName());
        }
        StaticCredentialsProvider longLivedCredentialsProvider = null;
        if (builder.longLivedCredentials != null) {
            longLivedCredentialsProvider = new StaticCredentialsProvider(builder.longLivedCredentials);
        } else if (builder.longLivedCredentialsProvider != null) {
            longLivedCredentialsProvider = builder.longLivedCredentialsProvider;
        }
        if (longLivedCredentialsProvider == null) {
            if (builder.clientConfiguration == null) {
                return new AWSSecurityTokenServiceClient();
            }
            return new AWSSecurityTokenServiceClient(builder.clientConfiguration);
        }
        if (builder.clientConfiguration == null) {
            return new AWSSecurityTokenServiceClient((AWSCredentialsProvider)longLivedCredentialsProvider);
        }
        return new AWSSecurityTokenServiceClient((AWSCredentialsProvider)longLivedCredentialsProvider, builder.clientConfiguration);
    }

    public void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.sessionCredentials.set(null);
    }

    public AWSSessionCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        Credentials tempCredentials = this.sessionCredentials.get();
        return new BasicSessionCredentials(tempCredentials.getAccessKeyId(), tempCredentials.getSecretAccessKey(), tempCredentials.getSessionToken());
    }

    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(this.roleArn).withDurationSeconds(this.roleSessionDurationSeconds).withRoleSessionName(this.roleSessionName);
        if (this.roleExternalId != null) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(this.roleExternalId);
        }
        AssumeRoleResult assumeRoleResult = this.securityTokenService.assumeRole(assumeRoleRequest);
        Credentials stsCredentials = assumeRoleResult.getCredentials();
        this.sessionCredentials.set(stsCredentials);
    }

    private boolean needsNewSession() {
        Credentials tempCredentials = this.sessionCredentials.get();
        if (tempCredentials == null) {
            return true;
        }
        long timeRemaining = tempCredentials.getExpiration().getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }

    public static final class Builder {
        private AWSCredentialsProvider longLivedCredentialsProvider;
        private AWSCredentials longLivedCredentials;
        private ClientConfiguration clientConfiguration;
        private final String roleArn;
        private final String roleSessionName;
        private String roleExternalId;
        private String serviceEndpoint;
        private int roleSessionDurationSeconds;
        private AWSSecurityTokenService sts;

        public Builder(String roleArn, String roleSessionName) {
            if (roleArn == null || roleSessionName == null) {
                throw new NullPointerException("You must specify a value for roleArn and roleSessionName");
            }
            this.roleArn = roleArn;
            this.roleSessionName = roleSessionName;
        }

        public Builder withLongLivedCredentials(AWSCredentials longLivedCredentials) {
            this.longLivedCredentials = longLivedCredentials;
            return this;
        }

        public Builder withLongLivedCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
            this.longLivedCredentialsProvider = longLivedCredentialsProvider;
            return this;
        }

        public Builder withClientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder withExternalId(String roleExternalId) {
            this.roleExternalId = roleExternalId;
            return this;
        }

        public Builder withRoleSessionDurationSeconds(int roleSessionDurationSeconds) {
            if (roleSessionDurationSeconds < 900 || roleSessionDurationSeconds > 3600) {
                throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - 1Hr");
            }
            this.roleSessionDurationSeconds = roleSessionDurationSeconds;
            return this;
        }

        public Builder withServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder withStsClient(AWSSecurityTokenService sts) {
            this.sts = sts;
            return this;
        }

        public STSAssumeRoleSessionCredentialsProvider build() {
            return new STSAssumeRoleSessionCredentialsProvider(this);
        }
    }
}

