/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.CaseDetails;
import com.amazonaws.services.support.model.transform.RecentCaseCommunicationsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CaseDetailsJsonMarshaller {
    private static CaseDetailsJsonMarshaller instance;

    public void marshall(CaseDetails caseDetails, JSONWriter jsonWriter) {
        if (caseDetails == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ccEmailAddressesList;
            jsonWriter.object();
            if (caseDetails.getCaseId() != null) {
                jsonWriter.key("caseId").value((Object)caseDetails.getCaseId());
            }
            if (caseDetails.getDisplayId() != null) {
                jsonWriter.key("displayId").value((Object)caseDetails.getDisplayId());
            }
            if (caseDetails.getSubject() != null) {
                jsonWriter.key("subject").value((Object)caseDetails.getSubject());
            }
            if (caseDetails.getStatus() != null) {
                jsonWriter.key("status").value((Object)caseDetails.getStatus());
            }
            if (caseDetails.getServiceCode() != null) {
                jsonWriter.key("serviceCode").value((Object)caseDetails.getServiceCode());
            }
            if (caseDetails.getCategoryCode() != null) {
                jsonWriter.key("categoryCode").value((Object)caseDetails.getCategoryCode());
            }
            if (caseDetails.getSeverityCode() != null) {
                jsonWriter.key("severityCode").value((Object)caseDetails.getSeverityCode());
            }
            if (caseDetails.getSubmittedBy() != null) {
                jsonWriter.key("submittedBy").value((Object)caseDetails.getSubmittedBy());
            }
            if (caseDetails.getTimeCreated() != null) {
                jsonWriter.key("timeCreated").value((Object)caseDetails.getTimeCreated());
            }
            if (caseDetails.getRecentCommunications() != null) {
                jsonWriter.key("recentCommunications");
                RecentCaseCommunicationsJsonMarshaller.getInstance().marshall(caseDetails.getRecentCommunications(), jsonWriter);
            }
            if (!(ccEmailAddressesList = (SdkInternalList)caseDetails.getCcEmailAddresses()).isEmpty() || !ccEmailAddressesList.isAutoConstruct()) {
                jsonWriter.key("ccEmailAddresses");
                jsonWriter.array();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonWriter.value((Object)ccEmailAddressesListValue);
                }
                jsonWriter.endArray();
            }
            if (caseDetails.getLanguage() != null) {
                jsonWriter.key("language").value((Object)caseDetails.getLanguage());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaseDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaseDetailsJsonMarshaller();
        }
        return instance;
    }
}

