/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.AttachmentDetails;
import com.amazonaws.services.support.model.Communication;
import com.amazonaws.services.support.model.transform.AttachmentDetailsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CommunicationJsonMarshaller {
    private static CommunicationJsonMarshaller instance;

    public void marshall(Communication communication, JSONWriter jsonWriter) {
        if (communication == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attachmentSetList;
            jsonWriter.object();
            if (communication.getCaseId() != null) {
                jsonWriter.key("caseId").value((Object)communication.getCaseId());
            }
            if (communication.getBody() != null) {
                jsonWriter.key("body").value((Object)communication.getBody());
            }
            if (communication.getSubmittedBy() != null) {
                jsonWriter.key("submittedBy").value((Object)communication.getSubmittedBy());
            }
            if (communication.getTimeCreated() != null) {
                jsonWriter.key("timeCreated").value((Object)communication.getTimeCreated());
            }
            if (!(attachmentSetList = (SdkInternalList)communication.getAttachmentSet()).isEmpty() || !attachmentSetList.isAutoConstruct()) {
                jsonWriter.key("attachmentSet");
                jsonWriter.array();
                for (AttachmentDetails attachmentSetListValue : attachmentSetList) {
                    if (attachmentSetListValue == null) continue;
                    AttachmentDetailsJsonMarshaller.getInstance().marshall(attachmentSetListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommunicationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommunicationJsonMarshaller();
        }
        return instance;
    }
}

