/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.Category;
import com.amazonaws.services.support.model.Service;
import com.amazonaws.services.support.model.transform.CategoryJsonMarshaller;

public class ServiceJsonMarshaller {
    private static ServiceJsonMarshaller instance;

    public void marshall(Service service, StructuredJsonGenerator jsonGenerator) {
        if (service == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList categoriesList;
            jsonGenerator.writeStartObject();
            if (service.getCode() != null) {
                jsonGenerator.writeFieldName("code").writeValue(service.getCode());
            }
            if (service.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(service.getName());
            }
            if (!(categoriesList = (SdkInternalList)service.getCategories()).isEmpty() || !categoriesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("categories");
                jsonGenerator.writeStartArray();
                for (Category categoriesListValue : categoriesList) {
                    if (categoriesListValue == null) continue;
                    CategoryJsonMarshaller.getInstance().marshall(categoriesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceJsonMarshaller();
        }
        return instance;
    }
}

