/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.supportapp.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.supportapp.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * SlackChannelConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class SlackChannelConfigurationMarshaller {

    private static final MarshallingInfo<String> CHANNELID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("channelId").build();
    private static final MarshallingInfo<String> CHANNELNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelName").build();
    private static final MarshallingInfo<String> CHANNELROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelRoleArn").build();
    private static final MarshallingInfo<Boolean> NOTIFYONADDCORRESPONDENCETOCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notifyOnAddCorrespondenceToCase").build();
    private static final MarshallingInfo<String> NOTIFYONCASESEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notifyOnCaseSeverity").build();
    private static final MarshallingInfo<Boolean> NOTIFYONCREATEORREOPENCASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notifyOnCreateOrReopenCase").build();
    private static final MarshallingInfo<Boolean> NOTIFYONRESOLVECASE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notifyOnResolveCase").build();
    private static final MarshallingInfo<String> TEAMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("teamId").build();

    private static final SlackChannelConfigurationMarshaller instance = new SlackChannelConfigurationMarshaller();

    public static SlackChannelConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(SlackChannelConfiguration slackChannelConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (slackChannelConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(slackChannelConfiguration.getChannelId(), CHANNELID_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getChannelName(), CHANNELNAME_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getChannelRoleArn(), CHANNELROLEARN_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getNotifyOnAddCorrespondenceToCase(), NOTIFYONADDCORRESPONDENCETOCASE_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getNotifyOnCaseSeverity(), NOTIFYONCASESEVERITY_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getNotifyOnCreateOrReopenCase(), NOTIFYONCREATEORREOPENCASE_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getNotifyOnResolveCase(), NOTIFYONRESOLVECASE_BINDING);
            protocolMarshaller.marshall(slackChannelConfiguration.getTeamId(), TEAMID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
