/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.EventType;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WorkflowReplayer<T> {
    private final Iterator<DecisionTask> taskIterator;
    private final AsyncDecisionTaskHandler taskHandler;
    private int replayUpToEventId;

    public WorkflowReplayer(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution);
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution);
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution);
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory);
    }

    public WorkflowReplayer(Iterator<DecisionTask> decisionTasks, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(Iterator<DecisionTask> decisionTasks, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler(ff);
    }

    public WorkflowReplayer(Iterator<DecisionTask> decisionTasks, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory);
    }

    public int getReplayUpToEventId() {
        return this.replayUpToEventId;
    }

    public void setReplayUpToEventId(int replayUpToEventId) {
        this.replayUpToEventId = replayUpToEventId;
    }

    public RespondDecisionTaskCompletedRequest replay() throws Exception {
        return this.taskHandler.handleDecisionTask(this.taskIterator);
    }

    public T loadWorkflow() throws Exception {
        Object definition = this.taskHandler.loadWorkflowThroughReplay((Iterator)this.taskIterator);
        POJOWorkflowDefinition pojoDefinition = (POJOWorkflowDefinition)definition;
        return (T)pojoDefinition.getImplementationInstance();
    }

    public List<AsyncTaskInfo> getAsynchronousThreadDump() throws Exception {
        return this.taskHandler.getAsynchronousThreadDump(this.taskIterator);
    }

    public String getAsynchronousThreadDumpAsString() throws Exception {
        return this.taskHandler.getAsynchronousThreadDumpAsString(this.taskIterator);
    }

    private abstract class DecisionTaskIterator
    implements Iterator<DecisionTask> {
        private DecisionTask next;
        private boolean initialized;

        private DecisionTaskIterator() {
        }

        protected void initNext() {
            this.initialized = true;
            this.next = this.getNextHistoryTask(null);
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.initNext();
            }
            if (this.next == null) {
                return false;
            }
            List events = this.next.getEvents();
            if (events.size() == 0) {
                return false;
            }
            if (WorkflowReplayer.this.replayUpToEventId == 0) {
                return true;
            }
            HistoryEvent firstEvent = (HistoryEvent)this.next.getEvents().get(0);
            return firstEvent.getEventId() <= (long)WorkflowReplayer.this.replayUpToEventId;
        }

        @Override
        public DecisionTask next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("hasNext() == false");
            }
            DecisionTask result = this.next;
            this.next = this.next.getNextPageToken() == null ? null : this.getNextHistoryTask(this.next.getNextPageToken());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected List<HistoryEvent> truncateHistory(List<HistoryEvent> events) {
            if (events.size() == 0) {
                return null;
            }
            if (WorkflowReplayer.this.replayUpToEventId == 0) {
                return events;
            }
            HistoryEvent lastEvent = events.get(events.size() - 1);
            if (lastEvent.getEventId() <= (long)WorkflowReplayer.this.replayUpToEventId) {
                return events;
            }
            ArrayList<HistoryEvent> truncated = new ArrayList<HistoryEvent>();
            for (HistoryEvent event : events) {
                if (event.getEventId() > (long)WorkflowReplayer.this.replayUpToEventId) break;
                truncated.add(event);
            }
            if (truncated.size() == 0) {
                return null;
            }
            return truncated;
        }

        protected abstract DecisionTask getNextHistoryTask(String var1);
    }

    private class HistoryIterableDecisionTaskIterator
    extends DecisionTaskIterator {
        private final WorkflowExecution workflowExecution;
        private final Iterable<HistoryEvent> history;

        public HistoryIterableDecisionTaskIterator(WorkflowExecution workflowExecution, Iterable<HistoryEvent> history) {
            this.workflowExecution = workflowExecution;
            this.history = history;
        }

        @Override
        protected DecisionTask getNextHistoryTask(String nextPageToken) {
            DecisionTask result = new DecisionTask();
            Iterator<HistoryEvent> iterator = this.history.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("empty history");
            }
            HistoryEvent startEvent = iterator.next();
            WorkflowExecutionStartedEventAttributes startedAttributes = startEvent.getWorkflowExecutionStartedEventAttributes();
            if (startedAttributes == null) {
                throw new IllegalStateException("first event is not WorkflowExecutionStarted: " + startEvent);
            }
            List<Object> events = new ArrayList<HistoryEvent>();
            events.add(startEvent);
            EventType eventType = null;
            int lastStartedIndex = 0;
            int index = 1;
            long previousStartedEventId = 0L;
            long startedEventId = 0L;
            while (iterator.hasNext()) {
                HistoryEvent event = iterator.next();
                eventType = EventType.fromValue((String)event.getEventType());
                events.add(event);
                if (eventType == EventType.DecisionTaskStarted) {
                    previousStartedEventId = startedEventId;
                    startedEventId = event.getEventId();
                    lastStartedIndex = index;
                }
                ++index;
            }
            if (events.size() > lastStartedIndex + 1) {
                events = events.subList(0, lastStartedIndex + 1);
            }
            result.setEvents(events);
            result.setPreviousStartedEventId(Long.valueOf(previousStartedEventId));
            result.setStartedEventId(Long.valueOf(startedEventId));
            result.setWorkflowExecution(this.workflowExecution);
            WorkflowType workflowType = startedAttributes.getWorkflowType();
            result.setWorkflowType(workflowType);
            return result;
        }
    }

    private class ServiceDecisionTaskIterator
    extends DecisionTaskIterator {
        private final AmazonSimpleWorkflow service;
        private final String domain;
        private final WorkflowExecution workflowExecution;

        public ServiceDecisionTaskIterator(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
            this.service = service;
            this.domain = domain;
            this.workflowExecution = workflowExecution;
        }

        @Override
        protected DecisionTask getNextHistoryTask(String nextPageToken) {
            WorkflowExecutionInfo executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(this.service, this.domain, this.workflowExecution);
            History history = WorkflowExecutionUtils.getHistoryPage(nextPageToken, this.service, this.domain, this.workflowExecution);
            DecisionTask task = new DecisionTask();
            List<HistoryEvent> events = history.getEvents();
            if ((events = this.truncateHistory(events)) == null) {
                return null;
            }
            task.setEvents(events);
            task.setWorkflowExecution(this.workflowExecution);
            task.setWorkflowType(executionInfo.getWorkflowType());
            task.setNextPageToken(history.getNextPageToken());
            return task;
        }
    }

    private final class WorkflowReplayerPOJOFactoryFactory
    extends POJOWorkflowDefinitionFactoryFactory {
        private final T workflowImplementation;

        private WorkflowReplayerPOJOFactoryFactory(T workflowImplementation) throws InstantiationException, IllegalAccessException {
            this.workflowImplementation = workflowImplementation;
            super.addWorkflowImplementationType(workflowImplementation.getClass());
        }

        @Override
        protected POJOWorkflowImplementationFactory getImplementationFactory(Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
            return new POJOWorkflowImplementationFactory(){

                @Override
                public Object newInstance(DecisionContext decisionContext) throws Exception {
                    return WorkflowReplayerPOJOFactoryFactory.this.workflowImplementation;
                }

                @Override
                public Object newInstance(DecisionContext decisionContext, Object[] constructorArgs) throws Exception {
                    return WorkflowReplayerPOJOFactoryFactory.this.workflowImplementation;
                }

                @Override
                public void deleteInstance(Object instance) {
                }
            };
        }
    }
}

