/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.taxsettings.model.TaxRegistrationEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutTaxRegistrationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> accountIds;
    private TaxRegistrationEntry taxRegistrationEntry;

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public BatchPutTaxRegistrationRequest withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public BatchPutTaxRegistrationRequest withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public void setTaxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry) {
        this.taxRegistrationEntry = taxRegistrationEntry;
    }

    public TaxRegistrationEntry getTaxRegistrationEntry() {
        return this.taxRegistrationEntry;
    }

    public BatchPutTaxRegistrationRequest withTaxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry) {
        this.setTaxRegistrationEntry(taxRegistrationEntry);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getTaxRegistrationEntry() != null) {
            sb.append("TaxRegistrationEntry: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutTaxRegistrationRequest)) {
            return false;
        }
        BatchPutTaxRegistrationRequest other = (BatchPutTaxRegistrationRequest)obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getTaxRegistrationEntry() == null ^ this.getTaxRegistrationEntry() == null) {
            return false;
        }
        return other.getTaxRegistrationEntry() == null || other.getTaxRegistrationEntry().equals(this.getTaxRegistrationEntry());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getTaxRegistrationEntry() == null ? 0 : this.getTaxRegistrationEntry().hashCode());
        return hashCode;
    }

    public BatchPutTaxRegistrationRequest clone() {
        return (BatchPutTaxRegistrationRequest)super.clone();
    }
}

