/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.taxsettings.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The error object for representing failures in the <code>BatchPutTaxRegistration</code> operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchPutTaxRegistrationError"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchPutTaxRegistrationError implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The unique account identifier for the account that the tax registration couldn't be added, or updated during the
     * <code>BatchPutTaxRegistration</code> operation.
     * </p>
     */
    private String accountId;
    /**
     * <p>
     * The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     */
    private String code;
    /**
     * <p>
     * The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     */
    private String message;

    /**
     * <p>
     * The unique account identifier for the account that the tax registration couldn't be added, or updated during the
     * <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param accountId
     *        The unique account identifier for the account that the tax registration couldn't be added, or updated
     *        during the <code>BatchPutTaxRegistration</code> operation.
     */

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * <p>
     * The unique account identifier for the account that the tax registration couldn't be added, or updated during the
     * <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @return The unique account identifier for the account that the tax registration couldn't be added, or updated
     *         during the <code>BatchPutTaxRegistration</code> operation.
     */

    public String getAccountId() {
        return this.accountId;
    }

    /**
     * <p>
     * The unique account identifier for the account that the tax registration couldn't be added, or updated during the
     * <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param accountId
     *        The unique account identifier for the account that the tax registration couldn't be added, or updated
     *        during the <code>BatchPutTaxRegistration</code> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchPutTaxRegistrationError withAccountId(String accountId) {
        setAccountId(accountId);
        return this;
    }

    /**
     * <p>
     * The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param code
     *        The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * <p>
     * The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @return The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     */

    public String getCode() {
        return this.code;
    }

    /**
     * <p>
     * The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param code
     *        The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchPutTaxRegistrationError withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * <p>
     * The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param message
     *        The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @return The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * </p>
     * 
     * @param message
     *        The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchPutTaxRegistrationError withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountId() != null)
            sb.append("AccountId: ").append(getAccountId()).append(",");
        if (getCode() != null)
            sb.append("Code: ").append(getCode()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchPutTaxRegistrationError == false)
            return false;
        BatchPutTaxRegistrationError other = (BatchPutTaxRegistrationError) obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null)
            return false;
        if (other.getAccountId() != null && other.getAccountId().equals(this.getAccountId()) == false)
            return false;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountId() == null) ? 0 : getAccountId().hashCode());
        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        return hashCode;
    }

    @Override
    public BatchPutTaxRegistrationError clone() {
        try {
            return (BatchPutTaxRegistrationError) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.taxsettings.model.transform.BatchPutTaxRegistrationErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
