/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.tnb;

import javax.annotation.Generated;

import com.amazonaws.services.tnb.model.*;

/**
 * Abstract implementation of {@code AWSTnbAsync}. Convenient method forms pass through to the corresponding overload
 * that takes a request object and an {@code AsyncHandler}, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSTnbAsync extends AbstractAWSTnb implements AWSTnbAsync {

    protected AbstractAWSTnbAsync() {
    }

    @Override
    public java.util.concurrent.Future<CancelSolNetworkOperationResult> cancelSolNetworkOperationAsync(CancelSolNetworkOperationRequest request) {

        return cancelSolNetworkOperationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelSolNetworkOperationResult> cancelSolNetworkOperationAsync(CancelSolNetworkOperationRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelSolNetworkOperationRequest, CancelSolNetworkOperationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSolFunctionPackageResult> createSolFunctionPackageAsync(CreateSolFunctionPackageRequest request) {

        return createSolFunctionPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSolFunctionPackageResult> createSolFunctionPackageAsync(CreateSolFunctionPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSolFunctionPackageRequest, CreateSolFunctionPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSolNetworkInstanceResult> createSolNetworkInstanceAsync(CreateSolNetworkInstanceRequest request) {

        return createSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSolNetworkInstanceResult> createSolNetworkInstanceAsync(CreateSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSolNetworkInstanceRequest, CreateSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSolNetworkPackageResult> createSolNetworkPackageAsync(CreateSolNetworkPackageRequest request) {

        return createSolNetworkPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSolNetworkPackageResult> createSolNetworkPackageAsync(CreateSolNetworkPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSolNetworkPackageRequest, CreateSolNetworkPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSolFunctionPackageResult> deleteSolFunctionPackageAsync(DeleteSolFunctionPackageRequest request) {

        return deleteSolFunctionPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSolFunctionPackageResult> deleteSolFunctionPackageAsync(DeleteSolFunctionPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSolFunctionPackageRequest, DeleteSolFunctionPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSolNetworkInstanceResult> deleteSolNetworkInstanceAsync(DeleteSolNetworkInstanceRequest request) {

        return deleteSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSolNetworkInstanceResult> deleteSolNetworkInstanceAsync(DeleteSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSolNetworkInstanceRequest, DeleteSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSolNetworkPackageResult> deleteSolNetworkPackageAsync(DeleteSolNetworkPackageRequest request) {

        return deleteSolNetworkPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSolNetworkPackageResult> deleteSolNetworkPackageAsync(DeleteSolNetworkPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSolNetworkPackageRequest, DeleteSolNetworkPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionInstanceResult> getSolFunctionInstanceAsync(GetSolFunctionInstanceRequest request) {

        return getSolFunctionInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionInstanceResult> getSolFunctionInstanceAsync(GetSolFunctionInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolFunctionInstanceRequest, GetSolFunctionInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageResult> getSolFunctionPackageAsync(GetSolFunctionPackageRequest request) {

        return getSolFunctionPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageResult> getSolFunctionPackageAsync(GetSolFunctionPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolFunctionPackageRequest, GetSolFunctionPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageContentResult> getSolFunctionPackageContentAsync(GetSolFunctionPackageContentRequest request) {

        return getSolFunctionPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageContentResult> getSolFunctionPackageContentAsync(GetSolFunctionPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolFunctionPackageContentRequest, GetSolFunctionPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageDescriptorResult> getSolFunctionPackageDescriptorAsync(
            GetSolFunctionPackageDescriptorRequest request) {

        return getSolFunctionPackageDescriptorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolFunctionPackageDescriptorResult> getSolFunctionPackageDescriptorAsync(
            GetSolFunctionPackageDescriptorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolFunctionPackageDescriptorRequest, GetSolFunctionPackageDescriptorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkInstanceResult> getSolNetworkInstanceAsync(GetSolNetworkInstanceRequest request) {

        return getSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkInstanceResult> getSolNetworkInstanceAsync(GetSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolNetworkInstanceRequest, GetSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkOperationResult> getSolNetworkOperationAsync(GetSolNetworkOperationRequest request) {

        return getSolNetworkOperationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkOperationResult> getSolNetworkOperationAsync(GetSolNetworkOperationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolNetworkOperationRequest, GetSolNetworkOperationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageResult> getSolNetworkPackageAsync(GetSolNetworkPackageRequest request) {

        return getSolNetworkPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageResult> getSolNetworkPackageAsync(GetSolNetworkPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolNetworkPackageRequest, GetSolNetworkPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageContentResult> getSolNetworkPackageContentAsync(GetSolNetworkPackageContentRequest request) {

        return getSolNetworkPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageContentResult> getSolNetworkPackageContentAsync(GetSolNetworkPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolNetworkPackageContentRequest, GetSolNetworkPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageDescriptorResult> getSolNetworkPackageDescriptorAsync(GetSolNetworkPackageDescriptorRequest request) {

        return getSolNetworkPackageDescriptorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSolNetworkPackageDescriptorResult> getSolNetworkPackageDescriptorAsync(GetSolNetworkPackageDescriptorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSolNetworkPackageDescriptorRequest, GetSolNetworkPackageDescriptorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<InstantiateSolNetworkInstanceResult> instantiateSolNetworkInstanceAsync(InstantiateSolNetworkInstanceRequest request) {

        return instantiateSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<InstantiateSolNetworkInstanceResult> instantiateSolNetworkInstanceAsync(InstantiateSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<InstantiateSolNetworkInstanceRequest, InstantiateSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSolFunctionInstancesResult> listSolFunctionInstancesAsync(ListSolFunctionInstancesRequest request) {

        return listSolFunctionInstancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSolFunctionInstancesResult> listSolFunctionInstancesAsync(ListSolFunctionInstancesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSolFunctionInstancesRequest, ListSolFunctionInstancesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSolFunctionPackagesResult> listSolFunctionPackagesAsync(ListSolFunctionPackagesRequest request) {

        return listSolFunctionPackagesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSolFunctionPackagesResult> listSolFunctionPackagesAsync(ListSolFunctionPackagesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSolFunctionPackagesRequest, ListSolFunctionPackagesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkInstancesResult> listSolNetworkInstancesAsync(ListSolNetworkInstancesRequest request) {

        return listSolNetworkInstancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkInstancesResult> listSolNetworkInstancesAsync(ListSolNetworkInstancesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSolNetworkInstancesRequest, ListSolNetworkInstancesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkOperationsResult> listSolNetworkOperationsAsync(ListSolNetworkOperationsRequest request) {

        return listSolNetworkOperationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkOperationsResult> listSolNetworkOperationsAsync(ListSolNetworkOperationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSolNetworkOperationsRequest, ListSolNetworkOperationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkPackagesResult> listSolNetworkPackagesAsync(ListSolNetworkPackagesRequest request) {

        return listSolNetworkPackagesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSolNetworkPackagesResult> listSolNetworkPackagesAsync(ListSolNetworkPackagesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSolNetworkPackagesRequest, ListSolNetworkPackagesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutSolFunctionPackageContentResult> putSolFunctionPackageContentAsync(PutSolFunctionPackageContentRequest request) {

        return putSolFunctionPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutSolFunctionPackageContentResult> putSolFunctionPackageContentAsync(PutSolFunctionPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<PutSolFunctionPackageContentRequest, PutSolFunctionPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutSolNetworkPackageContentResult> putSolNetworkPackageContentAsync(PutSolNetworkPackageContentRequest request) {

        return putSolNetworkPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutSolNetworkPackageContentResult> putSolNetworkPackageContentAsync(PutSolNetworkPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<PutSolNetworkPackageContentRequest, PutSolNetworkPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TerminateSolNetworkInstanceResult> terminateSolNetworkInstanceAsync(TerminateSolNetworkInstanceRequest request) {

        return terminateSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TerminateSolNetworkInstanceResult> terminateSolNetworkInstanceAsync(TerminateSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<TerminateSolNetworkInstanceRequest, TerminateSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSolFunctionPackageResult> updateSolFunctionPackageAsync(UpdateSolFunctionPackageRequest request) {

        return updateSolFunctionPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSolFunctionPackageResult> updateSolFunctionPackageAsync(UpdateSolFunctionPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSolFunctionPackageRequest, UpdateSolFunctionPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSolNetworkInstanceResult> updateSolNetworkInstanceAsync(UpdateSolNetworkInstanceRequest request) {

        return updateSolNetworkInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSolNetworkInstanceResult> updateSolNetworkInstanceAsync(UpdateSolNetworkInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSolNetworkInstanceRequest, UpdateSolNetworkInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSolNetworkPackageResult> updateSolNetworkPackageAsync(UpdateSolNetworkPackageRequest request) {

        return updateSolNetworkPackageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSolNetworkPackageResult> updateSolNetworkPackageAsync(UpdateSolNetworkPackageRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSolNetworkPackageRequest, UpdateSolNetworkPackageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ValidateSolFunctionPackageContentResult> validateSolFunctionPackageContentAsync(
            ValidateSolFunctionPackageContentRequest request) {

        return validateSolFunctionPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ValidateSolFunctionPackageContentResult> validateSolFunctionPackageContentAsync(
            ValidateSolFunctionPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<ValidateSolFunctionPackageContentRequest, ValidateSolFunctionPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ValidateSolNetworkPackageContentResult> validateSolNetworkPackageContentAsync(
            ValidateSolNetworkPackageContentRequest request) {

        return validateSolNetworkPackageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ValidateSolNetworkPackageContentResult> validateSolNetworkPackageContentAsync(
            ValidateSolNetworkPackageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<ValidateSolNetworkPackageContentRequest, ValidateSolNetworkPackageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
