/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.AbsoluteTimeRange;
import com.amazonaws.services.transcribe.model.ParticipantRole;
import com.amazonaws.services.transcribe.model.RelativeTimeRange;
import com.amazonaws.services.transcribe.model.TranscriptFilterType;
import com.amazonaws.services.transcribe.model.transform.TranscriptFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TranscriptFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String transcriptFilterType;
    private AbsoluteTimeRange absoluteTimeRange;
    private RelativeTimeRange relativeTimeRange;
    private String participantRole;
    private Boolean negate;
    private List<String> targets;

    public void setTranscriptFilterType(String transcriptFilterType) {
        this.transcriptFilterType = transcriptFilterType;
    }

    public String getTranscriptFilterType() {
        return this.transcriptFilterType;
    }

    public TranscriptFilter withTranscriptFilterType(String transcriptFilterType) {
        this.setTranscriptFilterType(transcriptFilterType);
        return this;
    }

    public TranscriptFilter withTranscriptFilterType(TranscriptFilterType transcriptFilterType) {
        this.transcriptFilterType = transcriptFilterType.toString();
        return this;
    }

    public void setAbsoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
        this.absoluteTimeRange = absoluteTimeRange;
    }

    public AbsoluteTimeRange getAbsoluteTimeRange() {
        return this.absoluteTimeRange;
    }

    public TranscriptFilter withAbsoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
        this.setAbsoluteTimeRange(absoluteTimeRange);
        return this;
    }

    public void setRelativeTimeRange(RelativeTimeRange relativeTimeRange) {
        this.relativeTimeRange = relativeTimeRange;
    }

    public RelativeTimeRange getRelativeTimeRange() {
        return this.relativeTimeRange;
    }

    public TranscriptFilter withRelativeTimeRange(RelativeTimeRange relativeTimeRange) {
        this.setRelativeTimeRange(relativeTimeRange);
        return this;
    }

    public void setParticipantRole(String participantRole) {
        this.participantRole = participantRole;
    }

    public String getParticipantRole() {
        return this.participantRole;
    }

    public TranscriptFilter withParticipantRole(String participantRole) {
        this.setParticipantRole(participantRole);
        return this;
    }

    public TranscriptFilter withParticipantRole(ParticipantRole participantRole) {
        this.participantRole = participantRole.toString();
        return this;
    }

    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    public Boolean getNegate() {
        return this.negate;
    }

    public TranscriptFilter withNegate(Boolean negate) {
        this.setNegate(negate);
        return this;
    }

    public Boolean isNegate() {
        return this.negate;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public TranscriptFilter withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public TranscriptFilter withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTranscriptFilterType() != null) {
            sb.append("TranscriptFilterType: ").append(this.getTranscriptFilterType()).append(",");
        }
        if (this.getAbsoluteTimeRange() != null) {
            sb.append("AbsoluteTimeRange: ").append(this.getAbsoluteTimeRange()).append(",");
        }
        if (this.getRelativeTimeRange() != null) {
            sb.append("RelativeTimeRange: ").append(this.getRelativeTimeRange()).append(",");
        }
        if (this.getParticipantRole() != null) {
            sb.append("ParticipantRole: ").append(this.getParticipantRole()).append(",");
        }
        if (this.getNegate() != null) {
            sb.append("Negate: ").append(this.getNegate()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptFilter)) {
            return false;
        }
        TranscriptFilter other = (TranscriptFilter)obj;
        if (other.getTranscriptFilterType() == null ^ this.getTranscriptFilterType() == null) {
            return false;
        }
        if (other.getTranscriptFilterType() != null && !other.getTranscriptFilterType().equals(this.getTranscriptFilterType())) {
            return false;
        }
        if (other.getAbsoluteTimeRange() == null ^ this.getAbsoluteTimeRange() == null) {
            return false;
        }
        if (other.getAbsoluteTimeRange() != null && !other.getAbsoluteTimeRange().equals(this.getAbsoluteTimeRange())) {
            return false;
        }
        if (other.getRelativeTimeRange() == null ^ this.getRelativeTimeRange() == null) {
            return false;
        }
        if (other.getRelativeTimeRange() != null && !other.getRelativeTimeRange().equals(this.getRelativeTimeRange())) {
            return false;
        }
        if (other.getParticipantRole() == null ^ this.getParticipantRole() == null) {
            return false;
        }
        if (other.getParticipantRole() != null && !other.getParticipantRole().equals(this.getParticipantRole())) {
            return false;
        }
        if (other.getNegate() == null ^ this.getNegate() == null) {
            return false;
        }
        if (other.getNegate() != null && !other.getNegate().equals(this.getNegate())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        return other.getTargets() == null || other.getTargets().equals(this.getTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTranscriptFilterType() == null ? 0 : this.getTranscriptFilterType().hashCode());
        hashCode = 31 * hashCode + (this.getAbsoluteTimeRange() == null ? 0 : this.getAbsoluteTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getRelativeTimeRange() == null ? 0 : this.getRelativeTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantRole() == null ? 0 : this.getParticipantRole().hashCode());
        hashCode = 31 * hashCode + (this.getNegate() == null ? 0 : this.getNegate().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        return hashCode;
    }

    public TranscriptFilter clone() {
        try {
            return (TranscriptFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TranscriptFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

