/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.Tag;
import com.amazonaws.services.transfer.model.WorkflowStep;
import com.amazonaws.services.transfer.model.transform.DescribedWorkflowMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribedWorkflow
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String description;
    private List<WorkflowStep> steps;
    private List<WorkflowStep> onExceptionSteps;
    private String workflowId;
    private List<Tag> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DescribedWorkflow withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DescribedWorkflow withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<WorkflowStep> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<WorkflowStep> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<WorkflowStep>(steps);
    }

    public DescribedWorkflow withSteps(WorkflowStep ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<WorkflowStep>(steps.length));
        }
        for (WorkflowStep ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public DescribedWorkflow withSteps(Collection<WorkflowStep> steps) {
        this.setSteps(steps);
        return this;
    }

    public List<WorkflowStep> getOnExceptionSteps() {
        return this.onExceptionSteps;
    }

    public void setOnExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
        if (onExceptionSteps == null) {
            this.onExceptionSteps = null;
            return;
        }
        this.onExceptionSteps = new ArrayList<WorkflowStep>(onExceptionSteps);
    }

    public DescribedWorkflow withOnExceptionSteps(WorkflowStep ... onExceptionSteps) {
        if (this.onExceptionSteps == null) {
            this.setOnExceptionSteps(new ArrayList<WorkflowStep>(onExceptionSteps.length));
        }
        for (WorkflowStep ele : onExceptionSteps) {
            this.onExceptionSteps.add(ele);
        }
        return this;
    }

    public DescribedWorkflow withOnExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
        this.setOnExceptionSteps(onExceptionSteps);
        return this;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public DescribedWorkflow withWorkflowId(String workflowId) {
        this.setWorkflowId(workflowId);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public DescribedWorkflow withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DescribedWorkflow withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getOnExceptionSteps() != null) {
            sb.append("OnExceptionSteps: ").append(this.getOnExceptionSteps()).append(",");
        }
        if (this.getWorkflowId() != null) {
            sb.append("WorkflowId: ").append(this.getWorkflowId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWorkflow)) {
            return false;
        }
        DescribedWorkflow other = (DescribedWorkflow)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getOnExceptionSteps() == null ^ this.getOnExceptionSteps() == null) {
            return false;
        }
        if (other.getOnExceptionSteps() != null && !other.getOnExceptionSteps().equals(this.getOnExceptionSteps())) {
            return false;
        }
        if (other.getWorkflowId() == null ^ this.getWorkflowId() == null) {
            return false;
        }
        if (other.getWorkflowId() != null && !other.getWorkflowId().equals(this.getWorkflowId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getOnExceptionSteps() == null ? 0 : this.getOnExceptionSteps().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowId() == null ? 0 : this.getWorkflowId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DescribedWorkflow clone() {
        try {
            return (DescribedWorkflow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribedWorkflowMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

