/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transfer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Each step type has its own <code>StepDetails</code> structure.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DecryptStepDetails" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DecryptStepDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     */
    private String type;
    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     */
    private String sourceFileLocation;
    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     */
    private String overwriteExisting;
    /**
     * <p>
     * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded
     * date.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the date of the upload.
     * </p>
     * <note>
     * <p>
     * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file is
     * uploaded in UTC.
     * </p>
     * </note></li>
     * </ul>
     */
    private InputFileLocation destinationFileLocation;

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @param name
     *        The name of the step, used as an identifier.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @return The name of the step, used as an identifier.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @param name
     *        The name of the step, used as an identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DecryptStepDetails withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * 
     * @param type
     *        The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @see EncryptionType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * 
     * @return The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @see EncryptionType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * 
     * @param type
     *        The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EncryptionType
     */

    public DecryptStepDetails withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of encryption used. Currently, this value must be <code>PGP</code>.
     * </p>
     * 
     * @param type
     *        The type of encryption used. Currently, this value must be <code>PGP</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EncryptionType
     */

    public DecryptStepDetails withType(EncryptionType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param sourceFileLocation
     *        Specifies which file to use as input to the workflow step: either the output from the previous step, or
     *        the originally uploaded file for the workflow.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow
     *        step uses the output file from the previous workflow step as input. This is the default value.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     *        </p>
     *        </li>
     */

    public void setSourceFileLocation(String sourceFileLocation) {
        this.sourceFileLocation = sourceFileLocation;
    }

    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies which file to use as input to the workflow step: either the output from the previous step, or
     *         the originally uploaded file for the workflow.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow
     *         step uses the output file from the previous workflow step as input. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     *         </p>
     *         </li>
     */

    public String getSourceFileLocation() {
        return this.sourceFileLocation;
    }

    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param sourceFileLocation
     *        Specifies which file to use as input to the workflow step: either the output from the previous step, or
     *        the originally uploaded file for the workflow.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow
     *        step uses the output file from the previous workflow step as input. This is the default value.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DecryptStepDetails withSourceFileLocation(String sourceFileLocation) {
        setSourceFileLocation(sourceFileLocation);
        return this;
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * 
     * @param overwriteExisting
     *        A flag that indicates whether to overwrite an existing file of the same name. The default is
     *        <code>FALSE</code>.</p>
     *        <p>
     *        If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *        processed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *        stops.
     *        </p>
     *        </li>
     * @see OverwriteExisting
     */

    public void setOverwriteExisting(String overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A flag that indicates whether to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.</p>
     *         <p>
     *         If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *         follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *         processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *         stops.
     *         </p>
     *         </li>
     * @see OverwriteExisting
     */

    public String getOverwriteExisting() {
        return this.overwriteExisting;
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * 
     * @param overwriteExisting
     *        A flag that indicates whether to overwrite an existing file of the same name. The default is
     *        <code>FALSE</code>.</p>
     *        <p>
     *        If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *        processed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *        stops.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OverwriteExisting
     */

    public DecryptStepDetails withOverwriteExisting(String overwriteExisting) {
        setOverwriteExisting(overwriteExisting);
        return this;
    }

    /**
     * <p>
     * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code>.
     * </p>
     * <p>
     * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     * processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing stops.
     * </p>
     * </li>
     * </ul>
     * 
     * @param overwriteExisting
     *        A flag that indicates whether to overwrite an existing file of the same name. The default is
     *        <code>FALSE</code>.</p>
     *        <p>
     *        If the workflow is processing a file that has the same name as an existing file, the behavior is as
     *        follows:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>TRUE</code>, the existing file is replaced with the file being
     *        processed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>OverwriteExisting</code> is <code>FALSE</code>, nothing happens, and the workflow processing
     *        stops.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OverwriteExisting
     */

    public DecryptStepDetails withOverwriteExisting(OverwriteExisting overwriteExisting) {
        this.overwriteExisting = overwriteExisting.toString();
        return this;
    }

    /**
     * <p>
     * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded
     * date.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the date of the upload.
     * </p>
     * <note>
     * <p>
     * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file is
     * uploaded in UTC.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @param destinationFileLocation
     *        Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     *        <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
     *        uploaded date.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
     *        uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
     *        uploaded the file.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
     *        uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
     *        </p>
     *        <note>
     *        <p>
     *        The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the
     *        file is uploaded in UTC.
     *        </p>
     *        </note></li>
     */

    public void setDestinationFileLocation(InputFileLocation destinationFileLocation) {
        this.destinationFileLocation = destinationFileLocation;
    }

    /**
     * <p>
     * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded
     * date.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the date of the upload.
     * </p>
     * <note>
     * <p>
     * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file is
     * uploaded in UTC.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @return Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     *         <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
     *         uploaded date.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
     *         uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
     *         uploaded the file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
     *         uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
     *         </p>
     *         <note>
     *         <p>
     *         The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the
     *         file is uploaded in UTC.
     *         </p>
     *         </note></li>
     */

    public InputFileLocation getDestinationFileLocation() {
        return this.destinationFileLocation;
    }

    /**
     * <p>
     * Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     * <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded
     * date.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded
     * files to an Amazon S3 bucket that is prefixed with the date of the upload.
     * </p>
     * <note>
     * <p>
     * The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the file is
     * uploaded in UTC.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @param destinationFileLocation
     *        Specifies the location for the file being decrypted. Use <code>${Transfer:UserName}</code> or
     *        <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or
     *        uploaded date.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt
     *        uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that
     *        uploaded the file.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt
     *        uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.
     *        </p>
     *        <note>
     *        <p>
     *        The system resolves <code>UploadDate</code> to a date format of <i>YYYY-MM-DD</i>, based on the date the
     *        file is uploaded in UTC.
     *        </p>
     *        </note></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DecryptStepDetails withDestinationFileLocation(InputFileLocation destinationFileLocation) {
        setDestinationFileLocation(destinationFileLocation);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getSourceFileLocation() != null)
            sb.append("SourceFileLocation: ").append(getSourceFileLocation()).append(",");
        if (getOverwriteExisting() != null)
            sb.append("OverwriteExisting: ").append(getOverwriteExisting()).append(",");
        if (getDestinationFileLocation() != null)
            sb.append("DestinationFileLocation: ").append(getDestinationFileLocation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DecryptStepDetails == false)
            return false;
        DecryptStepDetails other = (DecryptStepDetails) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getSourceFileLocation() == null ^ this.getSourceFileLocation() == null)
            return false;
        if (other.getSourceFileLocation() != null && other.getSourceFileLocation().equals(this.getSourceFileLocation()) == false)
            return false;
        if (other.getOverwriteExisting() == null ^ this.getOverwriteExisting() == null)
            return false;
        if (other.getOverwriteExisting() != null && other.getOverwriteExisting().equals(this.getOverwriteExisting()) == false)
            return false;
        if (other.getDestinationFileLocation() == null ^ this.getDestinationFileLocation() == null)
            return false;
        if (other.getDestinationFileLocation() != null && other.getDestinationFileLocation().equals(this.getDestinationFileLocation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getSourceFileLocation() == null) ? 0 : getSourceFileLocation().hashCode());
        hashCode = prime * hashCode + ((getOverwriteExisting() == null) ? 0 : getOverwriteExisting().hashCode());
        hashCode = prime * hashCode + ((getDestinationFileLocation() == null) ? 0 : getDestinationFileLocation().hashCode());
        return hashCode;
    }

    @Override
    public DecryptStepDetails clone() {
        try {
            return (DecryptStepDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.transfer.model.transform.DecryptStepDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
