/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.trustedadvisor;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.trustedadvisor.AWSTrustedAdvisor;
import com.amazonaws.services.trustedadvisor.AWSTrustedAdvisorClientBuilder;
import com.amazonaws.services.trustedadvisor.model.AWSTrustedAdvisorException;
import com.amazonaws.services.trustedadvisor.model.GetOrganizationRecommendationRequest;
import com.amazonaws.services.trustedadvisor.model.GetOrganizationRecommendationResult;
import com.amazonaws.services.trustedadvisor.model.GetRecommendationRequest;
import com.amazonaws.services.trustedadvisor.model.GetRecommendationResult;
import com.amazonaws.services.trustedadvisor.model.ListChecksRequest;
import com.amazonaws.services.trustedadvisor.model.ListChecksResult;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResult;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResult;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import com.amazonaws.services.trustedadvisor.model.ListOrganizationRecommendationsResult;
import com.amazonaws.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import com.amazonaws.services.trustedadvisor.model.ListRecommendationResourcesResult;
import com.amazonaws.services.trustedadvisor.model.ListRecommendationsRequest;
import com.amazonaws.services.trustedadvisor.model.ListRecommendationsResult;
import com.amazonaws.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest;
import com.amazonaws.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleResult;
import com.amazonaws.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest;
import com.amazonaws.services.trustedadvisor.model.UpdateRecommendationLifecycleResult;
import com.amazonaws.services.trustedadvisor.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.GetOrganizationRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.GetOrganizationRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.GetRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.GetRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListChecksRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListChecksResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationAccountsRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationAccountsResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationResourcesRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationResourcesResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListOrganizationRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListRecommendationResourcesRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListRecommendationResourcesResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ListRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.UpdateOrganizationRecommendationLifecycleRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.UpdateOrganizationRecommendationLifecycleResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.UpdateRecommendationLifecycleRequestProtocolMarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.UpdateRecommendationLifecycleResultJsonUnmarshaller;
import com.amazonaws.services.trustedadvisor.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSTrustedAdvisorClient
extends AmazonWebServiceClient
implements AWSTrustedAdvisor {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSTrustedAdvisor.class);
    private static final String DEFAULT_SIGNING_NAME = "trustedadvisor";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSTrustedAdvisorException.class));

    public static AWSTrustedAdvisorClientBuilder builder() {
        return AWSTrustedAdvisorClientBuilder.standard();
    }

    AWSTrustedAdvisorClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSTrustedAdvisorClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("trustedadvisor.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/trustedadvisor/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/trustedadvisor/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetOrganizationRecommendationResult getOrganizationRecommendation(GetOrganizationRecommendationRequest request) {
        request = (GetOrganizationRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetOrganizationRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOrganizationRecommendationResult executeGetOrganizationRecommendation(GetOrganizationRecommendationRequest getOrganizationRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOrganizationRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOrganizationRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOrganizationRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetOrganizationRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOrganizationRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOrganizationRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOrganizationRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOrganizationRecommendationResult getOrganizationRecommendationResult = (GetOrganizationRecommendationResult)response.getAwsResponse();
            return getOrganizationRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationResult getRecommendation(GetRecommendationRequest request) {
        request = (GetRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationResult executeGetRecommendation(GetRecommendationRequest getRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationResult getRecommendationResult = (GetRecommendationResult)response.getAwsResponse();
            return getRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChecksResult listChecks(ListChecksRequest request) {
        request = (ListChecksRequest)this.beforeClientExecution(request);
        return this.executeListChecks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChecksResult executeListChecks(ListChecksRequest listChecksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChecksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChecksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChecksRequestProtocolMarshaller(protocolFactory).marshall((ListChecksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChecksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChecks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChecksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChecksResult listChecksResult = (ListChecksResult)response.getAwsResponse();
            return listChecksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrganizationRecommendationAccountsResult listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsRequest request) {
        request = (ListOrganizationRecommendationAccountsRequest)this.beforeClientExecution(request);
        return this.executeListOrganizationRecommendationAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrganizationRecommendationAccountsResult executeListOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrganizationRecommendationAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrganizationRecommendationAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrganizationRecommendationAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListOrganizationRecommendationAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrganizationRecommendationAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrganizationRecommendationAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrganizationRecommendationAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrganizationRecommendationAccountsResult listOrganizationRecommendationAccountsResult = (ListOrganizationRecommendationAccountsResult)response.getAwsResponse();
            return listOrganizationRecommendationAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrganizationRecommendationResourcesResult listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesRequest request) {
        request = (ListOrganizationRecommendationResourcesRequest)this.beforeClientExecution(request);
        return this.executeListOrganizationRecommendationResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrganizationRecommendationResourcesResult executeListOrganizationRecommendationResources(ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrganizationRecommendationResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrganizationRecommendationResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrganizationRecommendationResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListOrganizationRecommendationResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrganizationRecommendationResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrganizationRecommendationResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrganizationRecommendationResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrganizationRecommendationResourcesResult listOrganizationRecommendationResourcesResult = (ListOrganizationRecommendationResourcesResult)response.getAwsResponse();
            return listOrganizationRecommendationResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrganizationRecommendationsResult listOrganizationRecommendations(ListOrganizationRecommendationsRequest request) {
        request = (ListOrganizationRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeListOrganizationRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrganizationRecommendationsResult executeListOrganizationRecommendations(ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrganizationRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrganizationRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrganizationRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ListOrganizationRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrganizationRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrganizationRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrganizationRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrganizationRecommendationsResult listOrganizationRecommendationsResult = (ListOrganizationRecommendationsResult)response.getAwsResponse();
            return listOrganizationRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationResourcesResult listRecommendationResources(ListRecommendationResourcesRequest request) {
        request = (ListRecommendationResourcesRequest)this.beforeClientExecution(request);
        return this.executeListRecommendationResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationResourcesResult executeListRecommendationResources(ListRecommendationResourcesRequest listRecommendationResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendationResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationResourcesResult listRecommendationResourcesResult = (ListRecommendationResourcesResult)response.getAwsResponse();
            return listRecommendationResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        request = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeListRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationsResult executeListRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationsResult listRecommendationsResult = (ListRecommendationsResult)response.getAwsResponse();
            return listRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateOrganizationRecommendationLifecycleResult updateOrganizationRecommendationLifecycle(UpdateOrganizationRecommendationLifecycleRequest request) {
        request = (UpdateOrganizationRecommendationLifecycleRequest)this.beforeClientExecution(request);
        return this.executeUpdateOrganizationRecommendationLifecycle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateOrganizationRecommendationLifecycleResult executeUpdateOrganizationRecommendationLifecycle(UpdateOrganizationRecommendationLifecycleRequest updateOrganizationRecommendationLifecycleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateOrganizationRecommendationLifecycleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateOrganizationRecommendationLifecycleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateOrganizationRecommendationLifecycleRequestProtocolMarshaller(protocolFactory).marshall((UpdateOrganizationRecommendationLifecycleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateOrganizationRecommendationLifecycleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateOrganizationRecommendationLifecycle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOrganizationRecommendationLifecycleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateOrganizationRecommendationLifecycleResult updateOrganizationRecommendationLifecycleResult = (UpdateOrganizationRecommendationLifecycleResult)response.getAwsResponse();
            return updateOrganizationRecommendationLifecycleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRecommendationLifecycleResult updateRecommendationLifecycle(UpdateRecommendationLifecycleRequest request) {
        request = (UpdateRecommendationLifecycleRequest)this.beforeClientExecution(request);
        return this.executeUpdateRecommendationLifecycle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRecommendationLifecycleResult executeUpdateRecommendationLifecycle(UpdateRecommendationLifecycleRequest updateRecommendationLifecycleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRecommendationLifecycleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecommendationLifecycleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecommendationLifecycleRequestProtocolMarshaller(protocolFactory).marshall((UpdateRecommendationLifecycleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRecommendationLifecycleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"TrustedAdvisor");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRecommendationLifecycle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRecommendationLifecycleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRecommendationLifecycleResult updateRecommendationLifecycleResult = (UpdateRecommendationLifecycleResult)response.getAwsResponse();
            return updateRecommendationLifecycleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

