/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.trustedadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.trustedadvisor.model.RecommendationPillar;
import com.amazonaws.services.trustedadvisor.model.RecommendationSource;
import com.amazonaws.services.trustedadvisor.model.transform.CheckSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<String> awsServices;
    private String description;
    private String id;
    private Map<String, String> metadata;
    private String name;
    private List<String> pillars;
    private String source;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public CheckSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getAwsServices() {
        return this.awsServices;
    }

    public void setAwsServices(Collection<String> awsServices) {
        if (awsServices == null) {
            this.awsServices = null;
            return;
        }
        this.awsServices = new ArrayList<String>(awsServices);
    }

    public CheckSummary withAwsServices(String ... awsServices) {
        if (this.awsServices == null) {
            this.setAwsServices(new ArrayList<String>(awsServices.length));
        }
        for (String ele : awsServices) {
            this.awsServices.add(ele);
        }
        return this;
    }

    public CheckSummary withAwsServices(Collection<String> awsServices) {
        this.setAwsServices(awsServices);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CheckSummary withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public CheckSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CheckSummary withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public CheckSummary addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public CheckSummary clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CheckSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPillars() {
        return this.pillars;
    }

    public void setPillars(Collection<String> pillars) {
        if (pillars == null) {
            this.pillars = null;
            return;
        }
        this.pillars = new ArrayList<String>(pillars);
    }

    public CheckSummary withPillars(String ... pillars) {
        if (this.pillars == null) {
            this.setPillars(new ArrayList<String>(pillars.length));
        }
        for (String ele : pillars) {
            this.pillars.add(ele);
        }
        return this;
    }

    public CheckSummary withPillars(Collection<String> pillars) {
        this.setPillars(pillars);
        return this;
    }

    public CheckSummary withPillars(RecommendationPillar ... pillars) {
        ArrayList<String> pillarsCopy = new ArrayList<String>(pillars.length);
        for (RecommendationPillar value : pillars) {
            pillarsCopy.add(value.toString());
        }
        if (this.getPillars() == null) {
            this.setPillars(pillarsCopy);
        } else {
            this.getPillars().addAll(pillarsCopy);
        }
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public CheckSummary withSource(String source) {
        this.setSource(source);
        return this;
    }

    public CheckSummary withSource(RecommendationSource source) {
        this.source = source.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAwsServices() != null) {
            sb.append("AwsServices: ").append(this.getAwsServices()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPillars() != null) {
            sb.append("Pillars: ").append(this.getPillars()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSummary)) {
            return false;
        }
        CheckSummary other = (CheckSummary)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAwsServices() == null ^ this.getAwsServices() == null) {
            return false;
        }
        if (other.getAwsServices() != null && !other.getAwsServices().equals(this.getAwsServices())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPillars() == null ^ this.getPillars() == null) {
            return false;
        }
        if (other.getPillars() != null && !other.getPillars().equals(this.getPillars())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        return other.getSource() == null || other.getSource().equals(this.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAwsServices() == null ? 0 : this.getAwsServices().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPillars() == null ? 0 : this.getPillars().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        return hashCode;
    }

    public CheckSummary clone() {
        try {
            return (CheckSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CheckSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

